import React, { Component } from 'react';
import { Form, Input, Select } from 'amos-framework';
import PropTypes from 'prop-types';
import './../../../styles/view/patrol/inputItem.scss';
import {
  queryRouteDetailAction,
  queryDeptByOrgCodeAction1,
  queryUserByDeptIdAction
} from '../../../services/checkService';
import { AmosAlert } from 'amos-framework';

import { Store } from 'amos-tool';
const lsTool = Store.lsTool;



const TextArea = Input.TextArea;
const FormItem = Form.Item;
const Option = Select.Option;

/**
 * 路线主表
 * @class RouteMain
 * @extends {Component}
 */
class RouteMain extends Component {
  constructor(props) {
    super(props);
    this.state = {
      form: {
        name: '',
        remark: '',
        tel: '',
        boss: '',
        deptId: '',
        userId: ''
      },
      rules: {
        name: [{ required: true, message: '请输入检查项名称' }],
        tel: [
          {
            validator: (rule, value, callback) => {
              var reg = /^1[0|1|2|3|4|5|7|8|9][0-9]\d{4,8}$/;
              if (reg.test(value) || !value) {
                callback();
              } else {
                callback(new Error('正确的手机电话号码'));
              }
            }
          }
        ]
      },
      userData: [],
      deptData: [],
      route: {}
    };
  }

  componentWillMount = () => {
    const { routeId } = this.props;
    routeId && this.onInit(routeId);
    this.queryDeptByOrgCode();
  };

  onInit = id => {
    queryRouteDetailAction(id).then(data => {

      let deptId = data.deptId;
      deptId && this.queryUserByDept(deptId);
      this.setState({ form: data });
    });
  };

  onChange = (key, value) => {
    const { form } = this.state;
    form[key] = value;
    this.setState({ form });
  };

  onDeptChange = (key, value) => {
    let keyd = lsTool.read('departmentdate');

    const { form } = this.state;


    // if(keyd!='null'){
    //     if(value!=keyd){

    //       AmosAlert.error('提示', '只能选择本部门');
    //       form[key] = '';
    //       this.setState({ userData: [] });
    //      this.setState({ form });

    //     }else{
    //       form[key] = value;
    //       this.queryUserByDept(value);
    //       this.setState({ form });
    //     }

    // }else{
    form[key] = value;
    this.queryUserByDept(value);
    this.setState({ form });

    //}




  };

  handleExecutorsChange = (userId, user) => {
    const { form } = this.state;
    form.boss = user.id;
    // form.tel = user.mobile ? user.mobile : user.telephone ? user.telephone : '';
    form.tel = user.mobile;
    this.setState({ form });
  };

  queryUserByDept = deptId => {
    queryUserByDeptIdAction(deptId).then(data => {
      this.setState({ userData: data });
    });
  };

  queryDeptByOrgCode = () => {
    queryDeptByOrgCodeAction1().then(data => {
      this.setState({ deptData: data });
    });
  };

  render() {
    const { form, rules, deptData, userData } = this.state;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 5 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };
    return (
      <div className="route-point-main-div">
        <Form model={form} rules={rules} ref={component => this.form = component}>
          <div className="input-item-div-left">
            <FormItem label={<span>路线名称</span>} field="name" {...formItemLayout}>
              <Input className="input-item-input" value={form.name} maxLength="50" onChange={e => this.onChange('name', e.target.value)} />
            </FormItem>
            <FormItem label={<span>责任人</span>} field="boss" {...formItemLayout}>
              <Select
                className="input-item-input"
                searchable
                data={userData}
                renderOption={item => <Option value={item.id}>{item.name}</Option>}
                value={form.boss}
                onChange={this.handleExecutorsChange}
              />
            </FormItem>
            <FormItem label={<span>备注说明</span>} field="remark" {...formItemLayout}>
              <TextArea className="input-item-text-area" rows={6} disableResize value={form.remark} onChange={e => this.onChange('remark', e.target.value)} />
            </FormItem>
          </div>
          <div className="input-item-div-right">
            <FormItem label={<span>责任部门</span>} field="deptId" {...formItemLayout}>
              <Select
                className="input-item-input"
                searchable
                data={deptData ? deptData : []}
                defaultValue={<Option value=''>请选择</Option>}
                renderOption={item => <Option value={item.sequenceNbr}>{item.departmentName}</Option>}
                value={form.deptId}
                onChange={e => this.onDeptChange('deptId', e)}
              />
            </FormItem>
            <FormItem label={<span>联系电话</span>} field="tel" {...formItemLayout}>
              <Input value={form.tel} className="input-item-input" onChange={e => this.onChange('tel', e.target.value)} />
            </FormItem>
          </div>
        </Form>
      </div>
    );
  }
}

RouteMain.propTypes = {
  routeId: PropTypes.number
};


export default RouteMain;
