import React, { Component } from 'react';
import RouteSearch from './RouteSearch';
import RouteTable from './RouteTable';
import SplitterLayout from '../../component/SplitLayout';

/**
 * 巡检路线
 *
 * @class Route
 * @extends {Component}
 */
class Route extends Component{
  state = {
    changeType: '',
    queryParam: {}
  }

  queryTableData = (requestParam) =>{
    this.setState({ changeType: 'query', queryParam: requestParam });
  }

  render() {
    const { changeType, queryParam } = this.state;
    return (
      <div className="patrol-page-content">
        <SplitterLayout>
          <RouteSearch rearch={this.queryTableData} />
        </SplitterLayout>
        <RouteTable  changeType={changeType} queryParam={queryParam}  />
      </div>
    );
  }
}

Route.propTypes = {
};

export default Route;
