import { Table ,Button } from 'amos-antd';
import React, { Component } from 'react';
import { Form, Search, message } from 'amos-framework';
import PropTypes from 'prop-types';
import '../../../../styles/view/patrol/routePoint.scss';
import { queryAuthPointAction } from '../../../../services/checkService';


const FormItem = Form.Item;
/**
 * 巡检项工具栏
 *
 * @class PointModal
 * @extends {Component}
 */
class PointModal extends Component {
  constructor(props) {
    super(props);
    this.state = {
      data: [],
      selectedRowKeys: [],
      selectedRows: [],
      queryParam: {
        code: '',
        name: ''
      }
    };
  }
    /**
   * 组件初始化调用
   */
  componentWillMount = () => {
    const { queryParam } = this.state;
    queryAuthPointAction(queryParam.code, queryParam.name).then(data => {
      this.setState({ data });
    });
  }

  onRowChanger = (selectedRowKeys, selectedRows) => {
    this.setState({ selectedRowKeys, selectedRows });
  }

  onIconClick = (key, e, value) => {
    const { queryParam } = this.state;
    if ('id' === key) {
      queryParam.code = value;
      this.setState({ queryParam });
    } else if ('name' === key) {
      queryParam.name = value;
      this.setState({ queryParam });
    }
    queryAuthPointAction(queryParam.code, queryParam.name).then(data => {
      this.setState({ data });
    });
  }

  onClickButton = () => {
    const { selectedRowKeys, selectedRows } = this.state;
    if (!selectedRowKeys || selectedRowKeys.length <= 0) {
      message.danger('没有选择检查点', 1);
      return;
    }
    this.props.callback(selectedRows);
  }

    /**
   * 获取表格表头
   */
  getTablecolumns = () => {
    return [
      {
        title: '点编号',
        dataIndex: 'pointNo',
        key: 'pointNo',
        width: '50%',
        className: 'uant-table-thead'
      },
      {
        title: '点名称',
        dataIndex: 'name',
        key: 'name',
        width: '50%',
        className: 'uant-table-thead'
      }
    ];
  }

  render() {
    let pagination = true;
    let { data , selectedRowKeys } = this.state;
    const rowSelection = {
      selectedRowKeys,
      onChange: (selectedRowKeys, selectedRows) => {
        this.onRowChanger(selectedRowKeys, selectedRows);
      }
    };

    return (
      <div >
        <div className="table-operations">
          <Form layout="inline">
            <FormItem label={<span>点编号</span>} >
              <Search
                icon="search"
                onIconClick={(e, value) => this.onIconClick('id', e, value)}
              />
            </FormItem>
            <FormItem label={<span>点名称</span>}  >
              <Search
                icon="search"
                onIconClick={(e, value) => this.onIconClick('name', e, value)}
              />
            </FormItem>
            <FormItem>
              <Button onClick={this.onClickButton}>添加</Button>
            </FormItem>
          </Form>
        </div>
        <Table
          rowKey={(record, index) => record.id}
          rowSelection={rowSelection}
          columns={this.getTablecolumns()}
          dataSource={data}
          pagination={pagination}
          bordered
          onRowClick={this.onDoubleClick}
        />
      </div>
    );
  }
}

PointModal.propTypes = {
  callback: PropTypes.func,
  routeId: PropTypes.string
};

export default PointModal;
