import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { exportExcel } from 'UTILS/tools';
import { patrolUrls } from 'CONSTS/urlConsts';
import AmosGridTable from './../../../component/table/table/AmosGridTable';
import ToolBar from './../../../component/toolbar';

const dropnavs = [
  {
    key: '1',
    text: '导出Excel',
    icon: 'user',
    href: 'jacascript::void(0)'
  }
];
const getColumns = () => {
  return [
    {
      title: '项目名称',
      dataIndex: 'name',
      key: 'name',
      width: 160,
      className: 'uant-table-thead'
    },
    {
      title: '应巡检次数',
      dataIndex: 'planTaskCount',
      key: 'planTaskCount',
      width: 120,
      className: 'uant-table-thead'
    },
    {
      title: '实际巡检次数',
      dataIndex: 'checkCount',
      key: 'checkCount',
      width: 120,
      className: 'uant-table-thead'
    },
   
    // {
    //  title: '计划完成次数',
     // dataIndex: 'ok',
    //  key: 'ok',
     // width: 120,
    //  className: 'uant-table-thead'
    // },
    {
      title: '漏检次数',
      dataIndex: 'missed',
      key: 'missed',
      width: 120,
      className: 'uant-table-thead'
    },
    {
      title: '漏检率%',
      dataIndex: 'missedRate',
      key: 'missedRate',
      width: 120,
      className: 'uant-table-thead'
    },
    {
      title: '不合格数',
      dataIndex: 'faild',
      key: 'faild',
      width: 120,
      className: 'uant-table-thead'
    },
    {
      title: '不合格率%',
      dataIndex: 'faildRate',
      key: 'faildRate',
      width: 120,
      className: 'uant-table-thead'
    },
    {
      title: '评分',
      dataIndex: 'score',
      key: 'score',
      width: 120,
      className: 'uant-table-thead'
    }
  ];
};

/**
 * 巡检情况统计分析-表格
 *
 * @class InspectionSituationTable
 * @extends {Component}
 */
class InspectionSituationTable extends Component {
  constructor(props) {
    super(props);
    this.pageConfig = {
      current: 1,
      pageSize: 10
    };
    this.state = {
      pagination: true,
      isChecked: true,
      selectedRows: [],
      selectedRowKeys: [],
      data: []
    };
  }

  onExportExcel = () => {
    const { searchParam } = this.props;
    exportExcel({ url: patrolUrls.inspectionSituationExportUrl, method: 'post', body: searchParam }, '巡检情况统计分析报表');
  }

  onClickBootBar = type => {
    if (type === '1') {
      this.onExportExcel();
    }
  };

  /**
   * 获取表格刷新方法
   */
  reload = r => {
    this.setState(
      {
        reload: () => {
          r();
          this.setState({ selectedRows: [], selectedRowKeys: [] });
        }
      },
      r()
    );
  };

  render() {
    let { dataList } = this.props;
    let { selectedRowKeys } = this.state;
    let defaultPageConfig = this.pageConfig;
    return (
      <div className="patrol-page-table">
        <ToolBar dropnavs={dropnavs} callBack={this.onClickBootBar} />
        <AmosGridTable
          columns={getColumns()}
          callBack={this.reload}
          dataList={dataList}
          selectedRowKeys={selectedRowKeys}
          getTableDataAction={()=>{}}
          getSelectedRows={this.getSelectedRows}
          rowClassName={this.getRowClassName}
          setPageConfig={this.setPageConfig}
          defaultPageConfig={defaultPageConfig}
          isPageable={false}
          isChecked={false}
        />
      </div>
    );
  }
}

InspectionSituationTable.propTypes = {
  queryParam: PropTypes.object,
  dataList: PropTypes.array,
  fetchData: PropTypes.func,
  count: PropTypes.number,
  searchParam: PropTypes.array
};

export default InspectionSituationTable;
