import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { DatePicker } from 'amos-antd';
import moment from 'moment';
import { Form, Button, Select, Input } from 'amos-framework';
import {
  planListAction,
  lineListAction,
  executeStateListAction
} from './../../../../services/statisticsService';

const { MonthPicker } = DatePicker;
const FormItem = Form.Item;
const Option = Select.Option;
const FORMAT = 'YYYY-MM-DD HH:mm:ss';

/**
 * 巡检情况统计分析-查询
 *
 * @class NewsSearch
 * @extends {Component}
 */
class NewsSearch extends Component {
  constructor(props) {
    super(props);
    this.state = {
      form: {
        startTime: {
          name: 'startTime',
          value: moment()
            .startOf('month')
            .format(FORMAT)
        },
        queryMonth: {
          name: 'queryMonth',
          value: moment()
            .endOf('month')
            .format('YYYY-MM')
        },
        endTime: {
          name: 'endTime',
          value: moment()
            .endOf('month')
            .format(FORMAT)
        },
        statisticsTyle: { name: 'statisticsTyle', value: '2' }
      },
      caliberList: [
        { name: '巡检计划', value: '0' },
        { name: '巡检点', value: '2' }
      ]
    };
  }

  componentWillMount() {
    this.handleSubmit();
  }

  onChange = (key, e) => {
    let { form } = this.state;
    form[key].value = e.target.value;
    this.setState(form);
  }

  onDateChange = (key, date) => {
    const { form } = this.state;
    form[key].value = moment(date).format(FORMAT);
    if (key === 'queryMonth'){
      form.startTime.value = moment(date).startOf('month').format(FORMAT);
      form.endTime.value = moment(date).endOf('month').format(FORMAT);
    }
    this.setState({ form });
  }

  onSelectChange = (key, value) => {
    let { form } = this.state;
    form[key].value = value;
    this.setState(form);
  }

  handleSubmit = () => {
    let { form } = this.state;
    const obj = {};
    Object.keys(form).map(e => {
      obj[e] = form[e].value;
    });
    this.props.search(obj);
  }

  onResetFields = () => {
    let { form } = this.state;
    form.queryMonth.value = moment().format(FORMAT);
    form.startTime.value = moment().startOf('month').format(FORMAT);
    form.endTime.value = moment().endOf('month').format(FORMAT);
    const obj = {};
    Object.keys(form).map(e => {
      obj[e] = form[e].value;
    });
    this.props.search(obj);
  }

  render() {
    const { form, caliberList } = this.state;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 4 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };
    return (
      <Form style={{ padding: '30px 0 0 0' }} className="basic-demo" model={form}>
        <FormItem label={<span>统计口径</span>} field="statisticsTyle" {...formItemLayout}>
          <Select
            data={caliberList}
            renderOption={item => <Option value={item.value}>{item.name}</Option>}
            value={form.statisticsTyle.value}
            className="search_Input"
            onChange={e => this.onSelectChange('statisticsTyle', e)}
          />
        </FormItem>
        <FormItem label={<span>月份</span>} field="queryMonth" {...formItemLayout}>
          <MonthPicker
            className="search_Input"
            value={moment(form.queryMonth.value)}
            allowClear={false}
            format="YYYY-MM"
            onChange={e => this.onDateChange('queryMonth', e)}
          />
        </FormItem>
        <FormItem label={<span>开始日期</span>} field="startTime" {...formItemLayout}>
          <DatePicker
            className="search_Input"
            value={moment(form.startTime.value)}
            allowClear={false}
            format={FORMAT}
            onChange={e => this.onDateChange('startTime', e)}
          />
        </FormItem>
        <FormItem label={<span>结束日期</span>} field="endTime" {...formItemLayout}>
          <DatePicker
            className="search_Input"
            value={moment(form.endTime.value)}
            allowClear={false}
            format={FORMAT}
            onChange={e => this.onDateChange('endTime', e)}
          />
        </FormItem>
        <FormItem  className="search-btn">
          <Button icon="search" onClick={this.handleSubmit}>查询</Button>
          <Button onClick={this.onResetFields}>重置</Button>
        </FormItem>
      </Form>
    );
  }
}

NewsSearch.propTypes = {
  search: PropTypes.func
};

export default NewsSearch;
