import React, { Component } from 'react';
import SplitterLayout from './../../../component/SplitLayout';
import {
  monthSituationAction
} from './../../../../services/statisticsService';
import Search from './Search';
import Table from './Table';
/**
 * 巡检情况统计分析
 *
 * @class InspectionSituation
 * @extends {Component}
 */
class MonthSituation extends Component {
  constructor(props) {
    super(props);
    this.state = {
      tableData: [],
      searchParam: [],
      titles: []
    };
  }

  onQueryTableData = () => {
    const { searchParam } = this.state;
    monthSituationAction(searchParam).then(d => {
      this.setState({ tableData: d.content, titles: d.titles });
    });
  }

  onSearchDataSyn = (searchParam) => {
    this.setState({ searchParam }, this.onQueryTableData);
  };

  render() {
    const { tableData, searchParam, titles } = this.state;
    return (
      <div className="patrol-page-content">
        <SplitterLayout>
          <Search search={this.onSearchDataSyn} />
        </SplitterLayout>
        <Table data={tableData} searchParam={searchParam} titles={titles} />
      </div>
    );
  }
}

export default MonthSituation;
