import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { exportExcel } from 'UTILS/tools';
import formatUrl from 'amos-processor/lib/utils/urlFormat';
import { patrolUrls } from 'CONSTS/urlConsts';
import AmosGridTable from './../../../component/table/table/AmosGridTable';
import ToolBar from './../../../component/toolbar';

const dropnavs = [
  {
    key: '1',
    text: '导出',
    icon: 'user',
    href: 'jacascript::void(0)'
  }
];
const getColumns = () => {
  return [
    {
      title: '姓名',
      dataIndex: 'userName',
      key: 'userName',
      width: 160,
      className: 'uant-table-thead'
    },
    {
      title: '部门',
      dataIndex: 'deptName',
      key: 'deptName',
      width: 120,
      className: 'uant-table-thead'
    },
    {
      title: '实际巡检次数',
      dataIndex: 'actCheckPointCount',
      key: 'actCheckPointCount ',
      width: 120,
      className: 'uant-table-thead'
    },
    {
      title: '计划巡检次数',
      dataIndex: 'counPointToCheck',
      key: 'counPointToCheck',
      width: 120,
      className: 'uant-table-thead'
    },
    {
      title: '计划完成次数',
      dataIndex: 'countPointFinish',
      key: 'countPointFinish',
      width: 120,
      className: 'uant-table-thead'
    },
    {
      title: '漏检次数',
      dataIndex: 'uncheckedPointCount',
      key: 'uncheckedPointCount',
      width: 120,
      className: 'uant-table-thead'
    },
    {
      title: '漏检率%',
      dataIndex: 'uncheckedPointRate',
      key: 'uncheckedPointRate',
      width: 120,
      className: 'uant-table-thead'
    },
    {
      title: '不合格数',
      dataIndex: 'notQualifiedPointCount',
      key: 'notQualifiedPointCount',
      width: 120,
      className: 'uant-table-thead'
    },
    {
      title: '不合格率%',
      dataIndex: 'notQualifiedPointCountRate',
      key: 'notQualifiedPointCountRate',
      width: 120,
      className: 'uant-table-thead'
    },
    {
      title: '评分',
      dataIndex: 'score',
      key: 'score',
      width: 120,
      className: 'uant-table-thead'
    },
    {
      title: '执行任务数',
      dataIndex: 'doTaskCount',
      key: 'doTaskCount',
      width: 120,
      className: 'uant-table-thead'
    },
    {
      title: '未完任务数',
      dataIndex: 'notFinishTaskCount',
      key: 'notFinishTaskCount',
      width: 120,
      className: 'uant-table-thead'
    },
    {
      title: '任务完成率%',
      dataIndex: 'finishTaskRate',
      key: 'finishTaskRate',
      width: 120,
      className: 'uant-table-thead'
    }
  ];
};

/**
 * 人员综合统计分析-表格
 *
 * @class TaskArrangementTable
 * @extends {Component}
 */
class TaskArrangementTable extends Component {
  constructor(props) {
    super(props);
    this.pageConfig = {
      current: 1,
      pageSize: 10
    };
    this.state = {
      pagination: true,
      isChecked: true,
      selectedRows: [],
      selectedRowKeys: [],
      data: []
    };
  }

  onExportExcel = () => {
    const { searchParam } = this.props;
    exportExcel({ url: formatUrl(patrolUrls.personStatisticsExportUrl, searchParam), method: 'get' }, '人员综合统计分析报表');
  }

  onClickBootBar = type => {
    if (type === '1') {
      this.onExportExcel();
    }
  };


  /**
   * 获取表格刷新方法
   */
  reload = r => {
    this.setState(
      {
        reload: () => {
          r();
          this.setState({ selectedRows: [], selectedRowKeys: [] });
        }
      },
      r()
    );
  };

  render() {
    let { dataList } = this.props;
    let { selectedRowKeys } = this.state;
    let defaultPageConfig = this.pageConfig;
    return (
      <div className="patrol-page-table">
        <ToolBar dropnavs={dropnavs} callBack={this.onClickBootBar} />
        <AmosGridTable
          rowKey="userName"
          columns={getColumns()}
          callBack={this.reload}
          dataList={dataList}
          selectedRowKeys={selectedRowKeys}
          getTableDataAction={()=>{}}
          getSelectedRows={this.getSelectedRows}
          rowClassName={this.getRowClassName}
          setPageConfig={this.setPageConfig}
          defaultPageConfig={defaultPageConfig}
          isPageable={false}
          isChecked={false}
        />
      </div>
    );
  }
}

TaskArrangementTable.propTypes = {
  queryParam: PropTypes.object,
  dataList: PropTypes.array,
  fetchData: PropTypes.func,
  count: PropTypes.number,
  searchParam: PropTypes.array
};

export default TaskArrangementTable;
