import React, { Component } from 'react';
import { Form, Input, AmosAlert, Button, Divider, Timeline } from 'amos-framework';
import { browserHistory } from 'amos-react-router';
import moment from 'moment';
import './../../../styles/view/patrol/inputItem.scss';
import { queryTaskDetailAction, feedbackTaskAction, printTaskDetailAction } from '../../../services/checkService';
import HasPermission from './../../component/toolbar/hasPermission';

const TextArea = Input.TextArea;
const FormItem = Form.Item;

class DetailTask extends Component {
  constructor(props) {
    super(props);
    this.state = {
      form: {
        taskID: '',
        message: ''
      },
      dataInfo: {},
      feedback: [],
      rules: {
        message: [{ required: true, message: '请输入办理意见' }]
      }
    };
  }

  /**
   * 组件初始化调用
   */
  componentWillMount = () => {
    const { taskID } = (this.props.location || {}).state || {};
    const { form } = this.state;
    form.taskID = taskID;
    this.setState({ form });
    this.onInit(taskID);
  };

  onChange = (key, value) => {
    const { form } = this.state;
    form[key] = value;
    this.setState({ form });
  };

  onInit = taskID => {
    queryTaskDetailAction(taskID).then(data => {
      this.setState({ feedback: data.feedback, dataInfo: data.taskInfo });
    });
  };
  formateStatus = value => {
    if (value === 0) {
      return '处理中';
    } else if (value === 1) {
      return '已完成';
    } else if (value === 2) {
      return '已取消';
    } else if (value === 3) {
      return '已超时';
    }
    return '未知';
  };
  handleSubmit = e => {
    const { form } = this.state;
    let taskInfo = Object();
    Object.assign(taskInfo, form);
    feedbackTaskAction(taskInfo).then(data => {
      if (!data) {
        AmosAlert.success('提示', '提交成功');
        browserHistory.goBack('/main/patrol/task');
      } else {
        AmosAlert.error('提示', data);
      }
    });
  };

  handlePrint = e => {
    const { form } = this.state;
    printTaskDetailAction(form.taskID).then(data => {
      this.printTask(data);
    });
  };

  printTask = result => {
    let newWindow = window.open('打印任务', '_blank');
    newWindow.document.write(result);
    newWindow.document.close();
    setTimeout(function() {
      newWindow.print();
      newWindow.close();
    }, 100);
  };

  handleCancel = e => {
    browserHistory.goBack('/main/patrol/task');
  };

  render() {
    const { form, rules, dataInfo, feedback } = this.state;

    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 4 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };
    const wrapperCol = {
      wrapperCol: {
        xs: { span: 24, offset: 0 },
        sm: { span: 14, offset: 4 }
      }
    };

    return (
      <div className="input_item_div">
        <Form model={dataInfo}>
          <FormItem label={<span>任务标题</span>} field="title" {...formItemLayout}>
            <Input className="input_item_Input" value={dataInfo.title} disabled />
          </FormItem>
          <FormItem label={<span>发起人</span>} field="publisherName" {...formItemLayout}>
            <Input className="input_item_Input" value={dataInfo.publisherName} disabled />
          </FormItem>
          <FormItem label={<span>执行人</span>} field="executor" {...formItemLayout}>
            <Input className="input_item_Input" value={dataInfo.executor} disabled />
          </FormItem>
          <FormItem label={<span>状态</span>} field="status" {...formItemLayout}>
            <Input className="input_item_Input" value={this.formateStatus(dataInfo.status)} disabled />
          </FormItem>
          <FormItem label={<span>要求完成时间</span>} field="finishTime" {...formItemLayout}>
            <Input
              className="input_item_Input"
              value={dataInfo.finishTime === null ? '' : moment(dataInfo.finishTime).format('YYYY-MM-DD HH:mm:ss')}
              disabled
            />
          </FormItem>
          <FormItem label={<span>任务内容</span>} field="remark" {...formItemLayout}>
            <TextArea className="input_item_Input" rows={4} disableResize disabled value={dataInfo.remark} />
          </FormItem>
        </Form>
        <Divider />
        <Timeline>
          {feedback &&
            feedback.map((item, i) => {
              if (item.feedbackPics && item.feedbackPics.length > 0) {
                return (
                  <Timeline.Item color="green">
                    <p>{item.message}</p>
                    <p>
                      {item.feedbackPics &&
                        item.feedbackPics.map((pic, i) => {
                          return <img className="task_detail_img" src={`data:image/png;base64,${pic}`} />;
                        })}
                    </p>
                    <p>
                      {item.userName} {moment(item.feedbackTime).format('YYYY/MM/DD HH:mm:ss')}
                    </p>
                  </Timeline.Item>
                );
              }
              return (
                <Timeline.Item color="green">
                  <p>{item.message}</p>
                  <p>
                    {item.userName} {moment(item.feedbackTime).format('YYYY/MM/DD HH:mm:ss')}
                  </p>
                </Timeline.Item>
              );
            })}
        </Timeline>
        <Divider />
        <Form model={form} rules={rules}>
          <FormItem label={<span>办理意见</span>} field="message" {...formItemLayout}>
            <TextArea className="input_item_Input" onChange={e => this.onChange('message', e.target.value)} rows={6} disableResize value={form.message} />
          </FormItem>
          <FormItem {...wrapperCol}>
            <HasPermission permissionCode="task">
              <Button onClick={this.handleSubmit}>提交</Button>
            </HasPermission>
            <Button onClick={this.handlePrint}>打印</Button>
            <Button onClick={this.handleCancel}>返回</Button>
          </FormItem>
        </Form>
      </div>
    );
  }
}

DetailTask.propTypes = {};

export default DetailTask;
