/**
 * webpack 打包配置文件
 * @author ilex
 */

var HtmlWebpackPlugin = require('amos-build/lib/plugins/HtmlWebpackPlugin');
var simpleConfig = require('amos-build/lib/simpleConfig');
const { tools } = require('ray-plugins');

const __ENV__ = tools.trim(process.env.NODE_ENV);
// ------------------------------------------------------
// 添加webpack加载别名,用于导包重定向，优化打包以及代码
// 此处需要自己进行定义
// 👻可修改
// ------------------------------------------------------
var alias = {
  MODEL: __dirname + '/src/model',
  UTILS: __dirname + '/src/utils',
  CONSTS: __dirname + '/src/consts',
  ROUTES: __dirname + '/src/routes',
  COM: __dirname + '/src/view/component',
  // SYSEXTEND: __dirname + '/src/sysextend',
  // BASEDATA: __dirname + '/src/sysextend/baseData',
  // BI: __dirname + '/src/sysextend/bi',
  // MA: __dirname + '/src/sysextend/ma',
  _MOCK: __dirname + '/src/_mock'
};

// ------------------------------------
// 入口点
// ------------------------------------
const prodEntry = {
  app: './src/entry/index.js'
};

const devEntry = {
  app: './src/entry/index.js',
};


var config = {
  tpl: './tpl.html',
  toFile: 'index.html',
  port: 3400,
  alias: alias,
  entry: __ENV__ === 'production' ? prodEntry : devEntry,
  sourceMap: __ENV__ === 'production' ? false : true
};

var defaultConfig = simpleConfig(config);

defaultConfig.name = 'maasview';


// if (__ENV__ === 'development'){
//   // 开发模式下，配置 proxy，跳过跨域问题
//   defaultConfig.devServer.proxy = {
//     '/securityBaseURI': {
//       // target: 'http://172.16.10.70:10005/',
//       target: 'http://172.16.3.41:8800/',
//       pathRewrite: { '^/securityBaseURI': '' }
//     },
//     '/baseURI': {
//       // target: 'http://172.16.10.70:10005/',
//       target: 'http://172.16.3.41:9000/',
//       pathRewrite: { '^/baseURI': '' }
//     },
//   };
// }


module.exports = defaultConfig;
