package com.yeejoin.amos.bank;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

import com.yeejoin.amos.op.core.entity.BusinessEntity;

/**
 * 拓扑图-事件列表
 * @author zhangzhihui
 *
 */
@Entity
@Table(name = "b_topography_event")
public class TopographyEvent extends BusinessEntity{

	/**
     * id
     */
    @Id
    @GeneratedValue(generator = "uuid")
    @GenericGenerator(name = "uuid", strategy = "uuid2")
    @Column(name = "id", nullable = false, length = 36)
    protected String id;
	/**
     * 
     */
    @Column(name = "node_machine", columnDefinition = "varchar(50) COMMENT '节点机器'")
    private String nodeMachine;
    /**
     * 
     */
    @Column(name = "event_content", columnDefinition = "varchar(255) COMMENT '事件内容'")
    private String eventContent;
    /**
     * 
     */
    @Column(name = "event_level", columnDefinition = "varchar(255) COMMENT '事件级别'")
    private String eventLevel;
	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}
	public String getNodeMachine() {
		return nodeMachine;
	}
	public void setNodeMachine(String nodeMachine) {
		this.nodeMachine = nodeMachine;
	}
	public String getEventContent() {
		return eventContent;
	}
	public void setEventContent(String eventContent) {
		this.eventContent = eventContent;
	}
	public String getEventLevel() {
		return eventLevel;
	}
	public void setEventLevel(String eventLevel) {
		this.eventLevel = eventLevel;
	}
}
