package com.yeejoin.amos.bank;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

import com.yeejoin.amos.op.core.entity.BusinessEntity;

/**
 * 拓扑图-节点详情
 * @author zhangzhihui
 *
 */
@Entity
@Table(name = "b_topography_node_detail")
public class TopographyNodeDetail extends BusinessEntity{

	/**
     * id
     */
    @Id
    @GeneratedValue(generator = "uuid")
    @GenericGenerator(name = "uuid", strategy = "uuid2")
    @Column(name = "id", nullable = false, length = 36)
    protected String id;
	/**
     * 
     */
    @Column(name = "nodeid", columnDefinition = "varchar(32) COMMENT '节点id'")
    private String nodeid;
    /**
     * 
     */
    @Column(name = "eqpName", columnDefinition = "varchar(32) COMMENT '设备名称'")
    private String eqpName;
    /**
     * 
     */
    @Column(name = "eqpIp", columnDefinition = "varchar(255) COMMENT '设备ip'")
    private String eqpIp;
    /**
     * 
     */
    @Column(name = "responseTime", columnDefinition = "varchar(255) COMMENT '响应时间'")
    private String responseTime;
    /**
     * 
     */
    @Column(name = "cpuUsage", columnDefinition = "varchar(255) COMMENT 'cpu使用率'")
    private String cpuUsage;
    /**
     * 
     */
    @Column(name = "innerStorage", columnDefinition = "varchar(255) COMMENT '内存使用率'")
    private String innerStorage;
    /**
     * 
     */
    @Column(name = "alarmNumber", columnDefinition = "int COMMENT '告警数'")
    private Integer alarmNumber;
    /**
     * 
     */
    @Column(name = "nodeDetail", columnDefinition = "text COMMENT '详情'")
    private String nodeDetail;
    
	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}
	public String getNodeid() {
		return nodeid;
	}
	public void setNodeid(String nodeid) {
		this.nodeid = nodeid;
	}
	public String getEqpName() {
		return eqpName;
	}
	public void setEqpName(String eqpName) {
		this.eqpName = eqpName;
	}
	public String getEqpIp() {
		return eqpIp;
	}
	public void setEqpIp(String eqpIp) {
		this.eqpIp = eqpIp;
	}
	public String getResponseTime() {
		return responseTime;
	}
	public void setResponseTime(String responseTime) {
		this.responseTime = responseTime;
	}
	public String getCpuUsage() {
		return cpuUsage;
	}
	public void setCpuUsage(String cpuUsage) {
		this.cpuUsage = cpuUsage;
	}
	public String getInnerStorage() {
		return innerStorage;
	}
	public void setInnerStorage(String innerStorage) {
		this.innerStorage = innerStorage;
	}
	public Integer getAlarmNumber() {
		return alarmNumber;
	}
	public void setAlarmNumber(Integer alarmNumber) {
		this.alarmNumber = alarmNumber;
	}
	public String getNodeDetail() {
		return nodeDetail;
	}
	public void setNodeDetail(String nodeDetail) {
		this.nodeDetail = nodeDetail;
	}
}
