package com.yeejoin.amos.bank;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

import com.yeejoin.amos.op.core.entity.BusinessEntity;

/**
 * 拓扑图-树
 * @author zhangzhihui
 *
 */
@Entity
@Table(name = "b_topography_tree")
public class TopographyTree extends BusinessEntity{

	/**
     * id
     */
    @Id
    @GeneratedValue(generator = "uuid")
    @GenericGenerator(name = "uuid", strategy = "uuid2")
    @Column(name = "id", nullable = false, length = 36)
    protected String id;
	/**
     * 
     */
    @Column(name = "code", columnDefinition = "varchar(32) COMMENT '编码'")
    private String code;
    /**
     * 
     */
    @Column(name = "parent_code", columnDefinition = "varchar(32) COMMENT '父编码'")
    private String parentCode;
    /**
     * 
     */
    @Column(name = "tree_code", columnDefinition = "varchar(255) COMMENT '树字段'")
    private String treeCode;
    /**
     * 
     */
    @Column(name = "name", columnDefinition = "varchar(255) COMMENT '名称'")
    private String name;
    /**
     * 
     */
    @Column(name = "type", columnDefinition = "int COMMENT '类型：1-网络拓扑图，2-PAMS'")
    private Integer type;
    /**
     * 
     */
    @Column(name = "`group`", columnDefinition = "varchar(255) COMMENT '分组'")
    private String group;
    
    @Column(name = "startId", columnDefinition = "varchar(255) COMMENT '起点 ID | b_bank_info'")//b_bank_info
    private String start_id;
    @Column(name = "endId", columnDefinition = "varchar(255) COMMENT '终点ID | b_bank_info'")//b_bank_info
    private String end_id;
    
    @Column(name = "org_code", columnDefinition = "varchar(255) COMMENT '单位'")
	private String orgCode;
	
	public String getOrgCode() {
		return orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}
    
    
    
    
    
	public String getGroup() {
		return group;
	}
	public void setGroup(String group) {
		this.group = group;
	}
	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}
	public String getCode() {
		return code;
	}
	public void setCode(String code) {
		this.code = code;
	}
	public String getParentCode() {
		return parentCode;
	}
	public void setParentCode(String parentCode) {
		this.parentCode = parentCode;
	}
	public String getTreeCode() {
		return treeCode;
	}
	public void setTreeCode(String treeCode) {
		this.treeCode = treeCode;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public Integer getType() {
		return type;
	}
	public void setType(Integer type) {
		this.type = type;
	}
	/**
	 * @return the start_id
	 */
	public String getStart_id() {
		return start_id;
	}
	/**
	 * @param start_id the start_id to set
	 */
	public void setStart_id(String start_id) {
		this.start_id = start_id;
	}
	/**
	 * @return the end_id
	 */
	public String getEnd_id() {
		return end_id;
	}
	/**
	 * @param end_id the end_id to set
	 */
	public void setEnd_id(String end_id) {
		this.end_id = end_id;
	}
}
