package com.yeejoin.amos.bank.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 告警点状态
 *
 */
public enum AlarmPointEnum {
	未确认未清除("未确认未清除", "未确认未清除"),
	未确认已清除("未确认已清除", "未确认已清除"),
	已确认未清除("已确认未清除", "已确认未清除"),
	已确认已清除("已确认已清除", "已确认已清除"),
	异常("异常", "异常"),
	正常("正常", "正常");
	
    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private String code;

    AlarmPointEnum(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public static AlarmPointEnum getEnum(String code) {
        AlarmPointEnum instance = null;
        for (AlarmPointEnum type : AlarmPointEnum.values()) {
            if (type.getCode().equals(code)) {
                instance = type;
                break;
            }
        }

        return instance;
    }

    public static String getEnumName(String code) {
        String name = "";
        for (AlarmPointEnum type : AlarmPointEnum.values()) {
            if (type.getCode().equals(code)) {
                name = type.getName();
                break;
            }
        }

        return name;
    }

    public static List<Map<String, String>> getEnumList() {
        List<Map<String, String>> list = new ArrayList<>();
        for (AlarmPointEnum e : AlarmPointEnum.values()) {
            Map<String, String> map = new HashMap<String, String>();
            map.put("code", e.getCode());
            map.put("name", e.getName());
            list.add(map);
        }
        return list;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}
