package com.yeejoin.amos.bank.common.enums;


/**
 * 自动巡检数据类型
 */
public enum AutoInspectionTypeEnum {
    
	商业银行通道("商业银行通道", "1"),
	NPC通道("NPC通道", "2"),
	MQ状态("MQ状态", "3"),
	设备状态("设备状态", "4");
    /**
     * 名称
     */
    private String name;
    /**
     * 类型
     */
    private String type;

    AutoInspectionTypeEnum(String name, String type) {
        this.name = name;
        this.type = type;
    }
    
    public static String getEnumType(String name) {
        for (AutoInspectionTypeEnum e : AutoInspectionTypeEnum.values()) {
            if(e.getName().equals(name)) {
            	return e.getType();
            }
        }
        return null;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

	public static String getEnumName(String aisleType) {
		for (AutoInspectionTypeEnum e : AutoInspectionTypeEnum.values()) {
            if(e.getType().equals(aisleType)) {
            	return e.getName();
            }
        }
        return null;
	}
}
