package com.yeejoin.amos.bank.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name = "b_bank_info")
@org.hibernate.annotations.Table(appliesTo = "b_bank_info", comment = "银行信息")
public class BankInfo extends BaseEntity {

    private static final long serialVersionUID = 8845057438343081252L;

    @Column(name = "name", columnDefinition = "varchar(255) COMMENT '名称'")
    private String name;
    @Column(name = "img", columnDefinition = "varchar(255) COMMENT '图标'")
    private String img;
    @Column(name = "lng", columnDefinition = "varchar(255) COMMENT '经度'")
    private String lng;
    @Column(name = "lat", columnDefinition = "varchar(255) COMMENT '纬度'")
    private String lat;
    @Column(name = "pams_position", columnDefinition = "varchar(255) COMMENT 'pams地图坐标'")
    private String pamsPosition;
    @Column(name = "en_name", columnDefinition = "varchar(255) COMMENT '英文名称'")
    private String eName;
    @Column(name = "an_name", columnDefinition = "varchar(255) COMMENT '别名'")
    private String aName;
    @Column(name = "is_center", columnDefinition = "tinyint(4) COMMENT '是否为中心点【0:否; 1:是】'")
    private int isCenter;
    @Column(name = "source_id", columnDefinition = "varchar(255) COMMENT '对接设备id'")
    private Integer sourceId;
    @Column(name = "status", columnDefinition = "bit(1) COMMENT '状态【0:正常; 1:异常】'")
    private int status = 0;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getImg() {
        return img;
    }

    public void setImg(String img) {
        this.img = img;
    }

    public String getLng() {
        return lng;
    }

    public void setLng(String lng) {
        this.lng = lng;
    }

    public String getLat() {
        return lat;
    }

    public void setLat(String lat) {
        this.lat = lat;
    }

    /**
     * @return the pamsPosition
     */
    public String getPamsPosition() {
        return pamsPosition;
    }

    /**
     * @param pamsPosition the pamsPosition to set
     */
    public void setPamsPosition(String pamsPosition) {
        this.pamsPosition = pamsPosition;
    }

    public String geteName() {
        return eName;
    }

    public void seteName(String eName) {
        this.eName = eName;
    }

    public String getaName() {
        return aName;
    }

    public void setaName(String aName) {
        this.aName = aName;
    }

    public int getIsCenter() {
        return isCenter;
    }

    public void setIsCenter(int isCenter) {
        this.isCenter = isCenter;
    }

    public Integer getSourceId() {
        return sourceId;
    }

    public void setSourceId(Integer sourceId) {
        this.sourceId = sourceId;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }
}
