package com.yeejoin.amos.bank.entity;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import net.sf.json.JSONObject;
import org.springframework.util.ObjectUtils;

public class EquipmentVo {
	/**
	 * 名称
	 */
	private String name;
	
	private String code;
	
	/**
	 * 节点id
	 */
	private long nodeId;
	/**
	 * 设备id
	 */
	private long id;

	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public long getNodeId() {
		return nodeId;
	}

	public void setNodeId(long nodeId) {
		this.nodeId = nodeId;
	}

	/**
	 * 描述
	 */
	private String descr;

	/**
	 * 用户id
	 */
	private String userId;

	/**
	 * 公司id
	 */
	private String orgCode;

	/**
	 * 设备模板id
	 */
	private Long eqpTmplId;

	/**
	 * 配置参数json数据：键值对
	 */
	private String cfgParamJson;

	/**
	 * 配置参数json数据：键值对
	 */
	private JSONObject cfgParamJsonObject = new JSONObject();

	/**
	 * 配置参数map
	 */
	private Map<String, Object> cfgParamMap;

	/**
	 * 设备是否有报警
	 */
	private Boolean isWarning = false;
	/**
	 * 设备类型
	 */
	private String type="";

	/**
	 * 设备logo
	 */
	private String logo;


	private String authOrg;
	/**
	 * 所属拓扑视图名称
	 */
	private String nodeName;
	
	private List<EquipmentQualityVo> attrs;

	public String getNodeName() {
		return nodeName;
	}

	public void setNodeName(String nodeName) {
		this.nodeName = nodeName;
	}

	public String getName() {
		return name;
	}


	public String[] getAuthOrg() {
		if (!ObjectUtils.isEmpty(authOrg)) {
			String str = authOrg.replace("[", "");
			str = str.replace("]", "");
			str = str.replace(" ", "");
			return str.split(",");
		}
		return null;
	}

	public void setAuthOrg(String authOrg) {
		this.authOrg = authOrg;
	}

	public void setName(String name) {
		if(name != null){
			name = name.trim();//去掉前后空格
		}
		this.name = name;
	}

	public String getDescr() {
		return descr;
	}

	public void setDescr(String descr) {
		this.descr = descr;
	}

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public Long getEqpTmplId() {
		return eqpTmplId;
	}

	public void setEqpTmplId(Long eqpTmplId) {
		this.eqpTmplId = eqpTmplId;
	}

	public String getOrgCode() {
		return orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public String getCfgParamJson() {
		return cfgParamJson;
	}

	public void setCfgParamJson(String cfgParamJson) {
		this.cfgParamJson = cfgParamJson;
	}

	@SuppressWarnings("unchecked")
	public Map<String, Object> getCfgParamMap() {
		// cfgParamJson转换成Map
		if (this.cfgParamMap == null
				&& StringUtils.isNotEmpty(this.cfgParamJson)) {
			Map<String,Object> classMap = new HashMap<String,Object>();
			classMap.put("quotaSelected",Map.class);
			cfgParamMap = (Map<String, Object>) JSONObject.toBean(
					JSONObject.fromObject(this.cfgParamJson), Map.class,classMap);
		}
		return cfgParamMap;
	}

	public Boolean getIsWarning() {
		return isWarning;
	}

	public void setIsWarning(Boolean isWarning) {
		this.isWarning = isWarning;
	}

	public String getLogo() {
		return logo;
	}

	public void setLogo(String logo) {
		this.logo = logo;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public JSONObject getCfgParamJsonObject() {
		return cfgParamJsonObject;
	}

	public void setCfgParamJsonObject(JSONObject cfgParamJsonObject) {
		this.cfgParamJsonObject = cfgParamJsonObject;
	}

	public List<EquipmentQualityVo> getAttrs() {
		return attrs;
	}

	public void setAttrs(List<EquipmentQualityVo> attrs) {
		this.attrs = attrs;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}
	
	
}
