package com.yeejoin.amos.bank.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @Author: xinglei
 * @Description: 运维值班
 * @Date: 2019/12/9 16:29
 */
@Entity
@Table( name= "b_situation_duty")
@org.hibernate.annotations.Table(appliesTo = "b_situation_duty",comment="运维值班")
public class MaintenanceDuty extends BaseEntity{

    private static final long serialVersionUID = -4566056588614613385L;
    /**
     * 岗位
     */
    @Column(name ="post", nullable=true,unique = true, columnDefinition="varchar(255) COMMENT '岗位'")
    private String post;
    /**
     * 白班值班人
     */
    @Column(name ="daytime_duty", columnDefinition="varchar(255) COMMENT '白班值班人'")
    private String daytimeDuty;
    /**
     * 夜班值班人
     */
    @Column(name ="night_duty", columnDefinition="varchar(255) COMMENT '夜班值班人'")
    private String nightDuty;
    /**
     * 值班日期
     */
    @Column(name ="duty_date", columnDefinition="varchar(255) COMMENT '值班日期'")
    private String dutyDate;
    /**
     * 排序
     */
    @Column(name ="sort", columnDefinition="int(10) COMMENT '排序'")
    private Integer sort;

    public String getPost() {
        return post;
    }

    public void setPost(String post) {
        this.post = post;
    }

    public String getDaytimeDuty() {
        return daytimeDuty;
    }

    public void setDaytimeDuty(String daytimeDuty) {
        this.daytimeDuty = daytimeDuty;
    }

    public String getNightDuty() {
        return nightDuty;
    }

    public void setNightDuty(String nightDuty) {
        this.nightDuty = nightDuty;
    }

    public String getDutyDate() {
        return dutyDate;
    }

    public void setDutyDate(String dutyDate) {
        this.dutyDate = dutyDate;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }
}
