package com.yeejoin.amos.spc.common.enums;

public enum RiskFactorsFlowStatusEnum {
    未启动("未启动", "0"),
    执行中("执行中", "1"),
    执行完成("执行完成", "3"),
    撤销("撤销", "4");

    private String name;

    private String code;

    private RiskFactorsFlowStatusEnum(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public static RiskFactorsFlowStatusEnum getEnum(String code) {
        for (RiskFactorsFlowStatusEnum type : RiskFactorsFlowStatusEnum.values()) {
            if (type.code.equals(code)) {
                return type;
            }
        }
        return null;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}
