package com.yeejoin.amos.spc.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 作业活动类型
 *
 * @author Administrator
 */
public enum TaskworkTypeEnum {
    重大工艺操作("重大工艺操作", "TASKWORK_TYPE_majorProcessWork"),
    检维修作业("检维修作业", "TASKWORK_TYPE_maintenanceWork"),
    特殊动火作业("特殊动火作业", "TASKWORK_TYPE_specialFireWork"),
    一级动火作业("一级动火作业", "TASKWORK_TYPE_firstFireWork"),
    二级动火作业("二级动火作业", "TASKWORK_TYPE_secondFireWork"),
    进入受限空间作业("进入受限空间作业", "TASKWORK_TYPE_confinedSpaceWork");

    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private String code;

    private TaskworkTypeEnum(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public static TaskworkTypeEnum getEnum(String code) {
        for (TaskworkTypeEnum type : TaskworkTypeEnum.values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public static List<Map<String, String>> getEnumList() {
        List<Map<String, String>> list = new ArrayList<>();
        for (TaskworkTypeEnum e : TaskworkTypeEnum.values()) {
            Map<String, String> map = new HashMap<String, String>();
            map.put("code", e.getCode());
            map.put("name", e.getName());
            list.add(map);
        }
        return list;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}
