package com.yeejoin.amos.spc.dao.entity;

import java.util.Date;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.springframework.data.annotation.LastModifiedDate;


/**
 * 管控措施
 * 
 */
@Entity
@Table(name="spc_control_measures")
@NamedQuery(name="SpcControlMeasure.findAll", query="SELECT s FROM SpcControlMeasure s")
public class SpcControlMeasure extends BasicEntity {
	private static final long serialVersionUID = 1L;

	private String name;
	/**
	 * 类别
	 */
	private String category;

	/**
	 * 类型
	 */
	private String type;
	
	@Column(name="creator_id")
	private String creatorId;

	

	@Column(name="org_code")
	private String orgCode;

	
	
	/**
	 * 控制措施数量
	 */
	private int measureNum;

	@Transient
	public int getMeasureNum() {
		return measureNum;
	}

	public void setMeasureNum(int measureNum) {
		this.measureNum = measureNum;
	}

	@LastModifiedDate
	@Column(name="update_date")
	private Date updateDate;

	public SpcControlMeasure() {
	}

	public String getCategory() {
		return this.category;
	}

	public void setCategory(String category) {
		this.category = category;
	}

	public String getCreatorId() {
		return this.creatorId;
	}

	public void setCreatorId(String creatorId) {
		this.creatorId = creatorId;
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getOrgCode() {
		return this.orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public String getType() {
		return this.type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public Date getUpdateDate() {
		return this.updateDate;
	}

	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}
	
	private List<SpcMeasuresContent> detailCxt;

	@Transient
	public List<SpcMeasuresContent> getDetailCxt() {
		return detailCxt;
	}

	public void setDetailCxt(List<SpcMeasuresContent> detailCxt) {
		this.detailCxt = detailCxt;
	}

}