package com.yeejoin.amos.spc.dao.entity;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import org.springframework.data.annotation.LastModifiedDate;


/**
 * 评价准则
 * 
 */
@Entity
@Table(name="spc_evaluate_norm")
@NamedQuery(name="SpcEvaluateNorm.findAll", query="SELECT s FROM SpcEvaluateNorm s")
public class SpcEvaluateNorm extends BasicEntity {
	private static final long serialVersionUID = 1L;

	
	private String name;
	
	@Lob
	private String content;

	@Column(name="creator_id")
	private String creatorId;

	@Column(name="evaluate_model_id")
	private Long evaluateModelId;


	@LastModifiedDate
	@Column(name="update_date")
	private Date updateDate;

	public SpcEvaluateNorm() {
	}

	public String getContent() {
		return this.content;
	}

	public void setContent(String content) {
		this.content = content;
	}


	public String getCreatorId() {
		return this.creatorId;
	}

	public void setCreatorId(String creatorId) {
		this.creatorId = creatorId;
	}

	

	public Long getEvaluateModelId() {
		return evaluateModelId;
	}

	public void setEvaluateModelId(Long evaluateModelId) {
		this.evaluateModelId = evaluateModelId;
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@LastModifiedDate
	public Date getUpdateDate() {
		return this.updateDate;
	}

	@LastModifiedDate
	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}

}