package com.yeejoin.amos.spc.dao.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import java.math.BigInteger;
import java.util.Date;


/**
 * The persistent class for the spc_risk_judgment_item database table.
 */
@Entity
@Table(name = "spc_risk_judgment_item")
@NamedQuery(name = "SpcRiskJudgmentItem.findAll", query = "SELECT s FROM SpcRiskJudgmentItem s")
public class SpcRiskJudgmentItem extends BasicEntity {


	private static final long serialVersionUID = 1L;

    /**
     * 是否删除（0：否；1：是）
     */
    private byte deleted;

    @Column(name = "input_type")
    private Integer inputType;

    @Column(name = "input_can_edit")
    private Integer inputCanEdit;

    /**
     * 输入是否需要（0：否；1：是）
     */
    @Column(name = "input_is_need")
    private byte inputIsNeed;


    /**
     * 输入项是否必填（0：否；1：是）
     */
    @Column(name = "input_is_required")
    private byte inputIsRequired;

    @Column(name = "input_name")
    private String inputName;

    /**
     * 唯一标识
     */
    @Column(name = "item_flag")
    private String itemFlag;

    /**
     * 风险研判项级别
     */
    @Column(name = "item_level")
    private int itemLevel;

    /**
     * 节点名称
     */
    @Column(name = "item_name")
    private String itemName;

    /**
     * 父节点编号
     */
    @Column(name = "item_parent_id")
    private BigInteger itemParentId;

    /**
     * 风险研判项类型（1：风险研判表；2：风险研判采集表）
     */
    @Column(name = "item_type")
    private byte itemType;

    @Column(name = "item_can_copy")
    private Integer itemCanCopy;

    /**
     * 拍照是否需要（0：否；1：是）
     */
    @Column(name = "photo_is_need")
    private byte photoIsNeed;

    /**
     * 拍照是否必填（0：否；1：是）
     */
    @Column(name = "photo_is_required")
    private byte photoIsRequired;

    /**
     * 备注是否需要（0：否；1：是）
     */
    @Column(name = "remark_is_need")
    private byte remarkIsNeed;

    /**
     * 备注是否必填（0：否；1：是）
     */
    @Column(name = "remark_is_required")
    private byte remarkIsRequired;

    /**
     * 选项是否需要（0：否；1：是）
     */
    @Column(name = "select_is_need")
    private byte selectIsNeed;

    /**
     * 选项是否必选（0：否；1：是）
     */
    @Column(name = "select_is_required")
    private byte selectIsRequired;

    /**
     * 选项json[{"id":1,"name":"否"}]
     */
    @Lob
    @Column(name = "select_json")
    private String selectJson;

    /**
     * 选项名称
     */
    @Column(name = "select_name")
    private String selectName;

    /**
     * 组织机构编号
     */
    @Column(name = "org_code")
    private String orgCode;

    /**
     * 部门编号
     */
    @Column(name = "department_code")
    private String departmentCode;

    /**
     * 记录修改时间
     */
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_date")
    private Date updateDate;

    public SpcRiskJudgmentItem() {
    }

    public byte getDeleted() {
        return this.deleted;
    }

    public void setDeleted(byte deleted) {
        this.deleted = deleted;
    }

    public byte getInputIsNeed() {
        return this.inputIsNeed;
    }

    public void setInputIsNeed(byte inputIsNeed) {
        this.inputIsNeed = inputIsNeed;
    }

    public byte getInputIsRequired() {
        return this.inputIsRequired;
    }

    public void setInputIsRequired(byte inputIsRequired) {
        this.inputIsRequired = inputIsRequired;
    }

    public String getInputName() {
        return this.inputName;
    }

    public void setInputName(String inputName) {
        this.inputName = inputName;
    }

    public String getItemFlag() {
        return this.itemFlag;
    }

    public void setItemFlag(String itemFlag) {
        this.itemFlag = itemFlag;
    }

    public int getItemLevel() {
        return this.itemLevel;
    }

    public void setItemLevel(int itemLevel) {
        this.itemLevel = itemLevel;
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public BigInteger getItemParentId() {
        return this.itemParentId;
    }

    public void setItemParentId(BigInteger itemParentId) {
        this.itemParentId = itemParentId;
    }

    public byte getItemType() {
        return this.itemType;
    }

    public void setItemType(byte itemType) {
        this.itemType = itemType;
    }

    public byte getPhotoIsNeed() {
        return this.photoIsNeed;
    }

    public void setPhotoIsNeed(byte photoIsNeed) {
        this.photoIsNeed = photoIsNeed;
    }

    public byte getPhotoIsRequired() {
        return this.photoIsRequired;
    }

    public void setPhotoIsRequired(byte photoIsRequired) {
        this.photoIsRequired = photoIsRequired;
    }

    public byte getRemarkIsNeed() {
        return this.remarkIsNeed;
    }

    public void setRemarkIsNeed(byte remarkIsNeed) {
        this.remarkIsNeed = remarkIsNeed;
    }

    public byte getRemarkIsRequired() {
        return this.remarkIsRequired;
    }

    public void setRemarkIsRequired(byte remarkIsRequired) {
        this.remarkIsRequired = remarkIsRequired;
    }

    public byte getSelectIsNeed() {
        return this.selectIsNeed;
    }

    public void setSelectIsNeed(byte selectIsNeed) {
        this.selectIsNeed = selectIsNeed;
    }

    public byte getSelectIsRequired() {
        return this.selectIsRequired;
    }

    public void setSelectIsRequired(byte selectIsRequired) {
        this.selectIsRequired = selectIsRequired;
    }

    public String getSelectJson() {
        return this.selectJson;
    }

    public void setSelectJson(String selectJson) {
        this.selectJson = selectJson;
    }

    public String getSelectName() {
        return this.selectName;
    }

    public void setSelectName(String selectName) {
        this.selectName = selectName;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Integer getItemCanCopy() {
        return itemCanCopy;
    }

    public void setItemCanCopy(Integer itemCanCopy) {
        this.itemCanCopy = itemCanCopy;
    }
    
    public String getDepartmentCode() {
		return departmentCode;
	}

	public void setDepartmentCode(String departmentCode) {
		this.departmentCode = departmentCode;
	}
}