package com.yeejoin.amos.spc.dao.entity;

import java.math.BigInteger;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;


/**
 * The persistent class for the spc_taskwork_audit_log database table.
 * 
 */
@Entity
@Table(name="spc_taskwork_audit_log")
@NamedQuery(name="SpcTaskworkAuditLog.findAll", query="SELECT s FROM SpcTaskworkAuditLog s")
public class SpcTaskworkAuditLog extends BasicEntity  {
	private static final long serialVersionUID = 1L;


	@Column(name="action_flag")
	private String actionFlag;

	private byte deleted;

	@Column(name="excute_department_id")
	private String excuteDepartmentId;

	@Column(name="excute_result")
	private String excuteResult;

	@Column(name="excute_state")
	private byte excuteState;

	@Column(name="excute_user_id")
	private String excuteUserId;

	@Lob
	@Column(name="flow_json")
	private String flowJson;

	@Column(name="flow_task_id")
	private String flowTaskId;

	@Column(name="flow_task_name")
	private String flowTaskName;

	@Column(name="flow_task_user_ids")
	private String flowTaskUserIds;

	private String remark;

	@Column(name="taskwork_id")
	private BigInteger taskworkId;

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name="update_date")
	private Date updateDate;

	public SpcTaskworkAuditLog() {
	}

	public String getActionFlag() {
		return this.actionFlag;
	}

	public void setActionFlag(String actionFlag) {
		this.actionFlag = actionFlag;
	}

	public byte getDeleted() {
		return this.deleted;
	}

	public void setDeleted(byte deleted) {
		this.deleted = deleted;
	}

	public String getExcuteDepartmentId() {
		return this.excuteDepartmentId;
	}

	public void setExcuteDepartmentId(String excuteDepartmentId) {
		this.excuteDepartmentId = excuteDepartmentId;
	}

	public String getExcuteResult() {
		return this.excuteResult;
	}

	public void setExcuteResult(String excuteResult) {
		this.excuteResult = excuteResult;
	}

	public byte getExcuteState() {
		return this.excuteState;
	}

	public void setExcuteState(byte excuteState) {
		this.excuteState = excuteState;
	}

	public String getExcuteUserId() {
		return this.excuteUserId;
	}

	public void setExcuteUserId(String excuteUserId) {
		this.excuteUserId = excuteUserId;
	}

	public String getFlowJson() {
		return this.flowJson;
	}

	public void setFlowJson(String flowJson) {
		this.flowJson = flowJson;
	}

	public String getFlowTaskId() {
		return this.flowTaskId;
	}

	public void setFlowTaskId(String flowTaskId) {
		this.flowTaskId = flowTaskId;
	}

	public String getFlowTaskName() {
		return this.flowTaskName;
	}

	public void setFlowTaskName(String flowTaskName) {
		this.flowTaskName = flowTaskName;
	}

	public String getFlowTaskUserIds() {
		return this.flowTaskUserIds;
	}

	public void setFlowTaskUserIds(String flowTaskUserIds) {
		this.flowTaskUserIds = flowTaskUserIds;
	}

	public String getRemark() {
		return this.remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public BigInteger getTaskworkId() {
		return this.taskworkId;
	}

	public void setTaskworkId(BigInteger taskworkId) {
		this.taskworkId = taskworkId;
	}

	public Date getUpdateDate() {
		return this.updateDate;
	}

	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}

}