package com.yeejoin.amos.bank.config;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.component.emq.EmqKeeper;
import org.typroject.tyboot.component.emq.EmqxListener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yeejoin.amos.bank.TopographyNode;
import com.yeejoin.amos.bank.common.enums.AlarmPointTypeEnum;
import com.yeejoin.amos.bank.common.enums.DevicePointEnum;
import com.yeejoin.amos.bank.common.enums.DeviceStatusEnum;
import com.yeejoin.amos.bank.dao.IDeviceRecord;
import com.yeejoin.amos.bank.dao.entity.Alarm;
import com.yeejoin.amos.bank.dao.entity.AlarmPoint;
import com.yeejoin.amos.bank.dao.repository.IAlarmRepository;
import com.yeejoin.amos.bank.dao.repository.ITopographyLineRepository;
import com.yeejoin.amos.bank.entity.DeviceRecord;
import com.yeejoin.amos.bank.entity.EquipmentQualityVo;
import com.yeejoin.amos.bank.remote.client.RiskModelRemoteClient;
import com.yeejoin.amos.bank.service.IAlarmPointService;
import com.yeejoin.amos.bank.service.IAlarmService;
import com.yeejoin.amos.bank.utils.HttpUtil;
import com.yeejoin.amos.bank.webSocket.WebsocketParam;
import com.yeejoin.amos.component.feign.config.InnerInvokException;
import com.yeejoin.amos.spc.business.dao.mapper.EquipmentMapper;
import com.yeejoin.amos.spc.business.remote.RemoteWebSocketServer;
import com.yeejoin.amos.spc.core.util.StringUtil;

import liquibase.integration.commandline.Main;

@Component
public class SelfSupportListener extends EmqxListener implements InitializingBean {

    private final Logger logger = LogManager.getLogger(SelfSupportListener.class);

    private static ObjectMapper mapper = new ObjectMapper();

    @Autowired
    private EmqKeeper emqKeeper;

    private static TaskExecutor taskExecutor;

    @Autowired
    EquipmentMapper equipmentMapper;

    @Autowired
    RiskModelRemoteClient riskModelRemoteClient;
    
    @Autowired
    IDeviceRecord iDeviceRecord;
    
    @Autowired
    ITopographyLineRepository nodeDao;
    
    @Autowired
    private RemoteWebSocketServer webSocketServer;
    @Autowired
    private IAlarmPointService alarmPointService;

    @Autowired
    private IAlarmService alarmService;
    @Autowired
    private IAlarmRepository iAlarmDao;
    /**
     * 监听主题
     */
    @Override
    public void afterPropertiesSet() throws Exception {
        emqKeeper.subscript(CommTopic.SUPPORT_PING.getTopic(), 2, this);
    }

    /**
     * 接收主题下的消息
     */
    @Override
    public void processMessage(String s, MqttMessage mqttMessage) throws Exception {

        blueprintMsgtransfer(mqttMessage);
    }


    /**
     * 消息处理
     *
     * @param mqttMessage
     */
    private void blueprintMsgtransfer(MqttMessage mqttMessage) {

        try {
        	
            String jsonStr = new String(mqttMessage.getPayload());
            System.out.println("----supprtmqtt received--jsonStr:" + jsonStr);
//            logger.error("----supprtmqtt received--jsonStr",jsonStr);
            JSONObject parseObject = JSON.parseObject(jsonStr);
            //logger.info("----supprtmqtt received sucess",parseObject);
            System.out.println("----supprtmqtt received sucess :"+ parseObject);
            Long eqpId = parseObject.getLong("eqpId");
            JSONArray jsonArray = parseObject.getJSONArray("metricDatas");
            JSONArray eqpConfigMap = parseObject.getJSONArray("eqpConfigMap");
            //获取ip
            String ipAddress = getIpAddress(eqpConfigMap);
            //楼层
            String lou =getIpAddress1(eqpConfigMap,"所属楼层");
            //3为坐标
            String sanwei =getIpAddress1(eqpConfigMap,"三维位置");
            
            String eqpName = parseObject.getString("eqpName");
            //orgcode
            String orgCode1 = parseObject.getString("orgCode");
            
            if (ObjectUtils.isEmpty(jsonArray)) {
                return;
            }
            //告警信息
            String metricKey="";
            //默认状态为正常           
            int statusByName=0 ;
//          jsonArray.forEach(e -> {
          	for (Object e : jsonArray){
                JSONObject object = (JSONObject) e;
                String string = object.getString("metricJson");
                 metricKey = object.getString("metricKey");
                if (!StringUtil.isNotEmpty(string)) {
                    return;
                }
                logger.error("---------shudu--string",string);
                System.out.println("----supprtmqtt chuli recording : "+ string);
                //{\"maxTime\":\"1\",\"packetLossRate\":\"0\",\"avgTime\":\"0\",\"minTime\":\"0\",\"发包数\":\"\",\"icmpPackSize\":\"32\",\"status\":\"通\"}
                JSONObject metricJson = JSONObject.parseObject(string);
              
				for (Map.Entry entry : metricJson.entrySet()) {
					// 指标名
					System.out.println("----start chuli device state : "+ entry);
					String remark = entry.getKey().toString();
					String statusName = entry.getValue().toString();
					
					if (remark.equals("status")) {
						DeviceRecord record = new DeviceRecord();
			            record.setDeviceId(eqpId);
						 statusByName = DeviceStatusEnum.getStatusByName(statusName);
						record.setDeviceStatus(statusByName);
						record.setMetricData(string);
					    record.setName(eqpName + " " + ipAddress);
						iDeviceRecord.save(record);
						TopographyNode node = equipmentMapper.queryNodeBySourceId(String.valueOf(eqpId));
						
						//触发风险合格不合格
						EquipmentQualityVo queryEquipmentPoint = equipmentMapper.queryEquipmentPoint(eqpId, remark);
						Long equipmentsPointId = queryEquipmentPoint.getId();
						List<Long> riskFactorId = equipmentMapper.judgeEquipmentExists(equipmentsPointId);
						if ("不通".equals(statusName)) {
							Integer value = DevicePointEnum.getValue("异常");
							equipmentMapper.updateEquipmentPointStatus(value, queryEquipmentPoint.getId());
						} else {
							Integer value = DevicePointEnum.getValue("正常");
							equipmentMapper.updateEquipmentPointStatus(value, queryEquipmentPoint.getId());
						}
						//修改rpn值
						for (int j = 0; j < riskFactorId.size(); j++) {
							try {
								riskModelRemoteClient.updateEquipmentAlarmData(riskFactorId.get(j));
								System.out.println("----udpate riskFactor sucess");
							} catch (InnerInvokException e1) {
								logger.error("update rpn fail " + e1.getMessage());
							}
						}
						
						if(null!=node) {
							node.setNumber(statusByName);
							node.setState(statusByName);
							equipmentMapper.updateNodeState(node);
							String nodeDetail = (statusByName== 0 ? "[{\"name\":\"通信状态\",\"value\":\"正常\"}]":"[{\"name\":\"通信状态\",\"value\":\"异常\"}]");
							equipmentMapper.updateNodeDetail(node.getId(), nodeDetail);
						    try {
								webSocketServer.sendMessage("refresh", "self");
							} catch (Exception e1) {
								 logger.error("webSocketServer send self! ");
							}
						}
					}
				}
          	};
//            });

            
            //增加报警           
         	List<AlarmPoint> alarmPoint= alarmPointService.selectPointTypeAndPointId(AlarmPointTypeEnum.设备.getCode(), eqpId);	
      		if(alarmPoint!=null&&alarmPoint.size()>0){
      			//存在报警，判断当前状态是不是合格，合格则删除上次的报警			
      			if(statusByName==0){
      			//删除告警				     				
      			alarmPointService.delete(alarmPoint.get(0));     				
      			}
      		}else{
      			//不存在，判断当前状态是不是合格，不合格新增，合格不做任何操作
      			if(statusByName!=0){
      				//增加告警
      				AlarmPoint	alarmPoint1=new AlarmPoint();
      				alarmPoint1.setPointId(eqpId);
      				alarmPoint1.setPointType(AlarmPointTypeEnum.设备.getCode());
      				alarmPoint1.setUpdateDate(new Date());
      				alarmPoint1.setIsAlarm(1);//不合格    	
      				alarmPoint1.setContent(eqpName+"-"+ipAddress+"-"+metricKey);    
      				alarmPoint1.setCode(orgCode1);
      				alarmPoint1.setPointName(eqpName);
      				Map<String, Object> map = new HashMap<>();
      				map.put("position",sanwei);
      				map.put("storey", lou);
      				map.put("levelStr", "impEqu_04");
      				
      				alarmPoint1.setPointAttrs(JSON.toJSONString(map));
      				alarmPointService.save(alarmPoint1);
      			    //推送告警
      				List<AlarmPoint> list=   alarmPointService.findAll();     				
     				WebsocketParam  param=new WebsocketParam("alarmPoint", JSON.toJSONString(list));
     				Properties props = PropertiesLoaderUtils.loadAllProperties("application.properties");
                    String url = (String) props.get("params.remoteWebsocketUrl") + "/generic/sendMessage";
                    HttpUtil.PostJson(url, JSON.toJSONString(param));
      				
      			}
      		}
            
            //增建告警记录表            
      	     //告警记录          
            List<Alarm> curAlarmList = alarmService.findByQueryColumn(eqpId+"");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (curAlarmList != null && curAlarmList.size() > 0) {
//            	if("异常".equals(curAlarmList.get(0).getCurrentState())){
            		 Alarm alarm = curAlarmList.get(0);
                     alarm.setUpdateDate(df.format(new Date()));
                     iAlarmDao.save(alarm);            		
//            	}               
            } else {
                Alarm alarm = new Alarm();
                alarm.setSourceId(eqpId+"");
                alarm.setAlarmLevel("紧急告警");
                alarm.setAlarmReason("");
                alarm.setAlarmSourceIp(ipAddress+"");
                alarm.setAlarmSourceName(eqpName);
                alarm.setAlarmSourceType(metricKey);
                alarm.setClearDate("");
                alarm.setClearPerson(metricKey);
                alarm.setContinueDate("");
                if(statusByName!=0){
                alarm.setCurrentState("异常");
                }else{
                alarm.setCurrentState("正常");	
                }
                alarm.setEnsureDate("");
                alarm.setHappenDate("");
                alarm.setEnsurePerson("");
                alarm.setOrgCode(orgCode1);
                alarm.setUpdateDate(df.format(new Date()));
                alarm.setQueryColumn(eqpId+"");          
                iAlarmDao.save(alarm);                
            }                              
        } catch (Exception e) {
            logger.error("消息流转报错.");
            logger.error(e.getMessage(), e);
            e.printStackTrace();
        }
    }
    
    
    
    public String getIpAddress1(JSONArray eqpConfigMap,String name) {
    	//配置信息
        if(null != eqpConfigMap && eqpConfigMap.size() > 0) {
        	for (Object object : eqpConfigMap) {
        		JSONObject  obj = (JSONObject) object;
        		String str = obj.getString("displayName");
        		if(str.contains(name)) {
        			String ip = obj.getString("valueStr");
        			return ip;
        		}
			}
        }
        return null;
    }
    
    
    
    
    
    public String getIpAddress(JSONArray eqpConfigMap) {
    	//配置信息
        if(null != eqpConfigMap && eqpConfigMap.size() > 0) {
        	for (Object object : eqpConfigMap) {
        		JSONObject  obj = (JSONObject) object;
        		String str = obj.getString("displayName");
        		if(str.contains("IP")) {
        			String ip = obj.getString("valueStr");
        			return ip;
        		}
			}
        }
        return null;
    }
}
