package com.yeejoin.amos.bank.controller;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import com.yeejoin.amos.bank.service.InspectionService;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.spc.business.controller.BaseController;
import com.yeejoin.amos.spc.business.param.ReginParams;
import com.yeejoin.amos.spc.business.remote.RemoteSecurityService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

/**
 * 巡检controller
 * @author DELL
 *
 */
@RestController
@RequestMapping(value = "/bank/inspection")
@Api(value = "/bank/inspection", tags = {"巡检API"})
public class InspectionController extends BaseController{

	@Autowired
	private InspectionService inspectionService;
	@Autowired
    RemoteSecurityService remoteSecurityService;
	@GetMapping(value = "/rightTopChart", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "查询主页右上角图片", notes = "查询主页右上角图片")
    public CommonResponse rightTopChartData(@ApiParam(value = "公司id", required = false)String companyId) {
//		if(companyId == null || "".equals(companyId)) {
//			ReginParams reginParams = getSelectedOrgInfo();
//			companyId = getCompanyId(reginParams);
//			
//			  return CommonResponseUtil.failure();
//		}
		ReginParams reginParams = getSelectedOrgInfo();
		companyId = getCompanyId(reginParams);
        return CommonResponseUtil.success(inspectionService.queryRightTopChart(companyId));
    }
	
	@GetMapping(value = "/bottomTable", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "查询主页右下角table", notes = "查询主页右下角table")
    public CommonResponse bottomTableData() {
        return CommonResponseUtil.success(inspectionService.queryBottomTableData());
    }
	
	 @ApiOperation(value = "巡检计划执行情况列表", notes = "巡检计划执行情况列表")
	    @GetMapping(value = "/patrolPlanList")
	    public CommonResponse patrolPlanList(@ApiParam(value = "当前条数", required = true) @RequestParam Integer start,
	                                         @ApiParam(value = "到条数", required = true) @RequestParam Integer end,
	                                         @ApiParam(value = "部门编号") @RequestParam(required = false) String deptId,
	                                         @ApiParam(value = "部门编号") @RequestParam(required = false) String deptName) {
	        try {
	            return CommonResponseUtil.success(inspectionService.queryRightTopChartlist(start, end, deptId,deptName));
	        } catch (Exception e) {
	            return CommonResponseUtil.failure("查询异常");
	        }
	    }
	 
	 
	 

		@GetMapping(value = "/getporint", produces = "application/json;charset=UTF-8")
	    @ApiOperation(value = "点的状态", notes = "点的状态")
	    public CommonResponse getporint(@ApiParam(value = "公司id", required = false)String pointid) {
			
			java.util.HashMap<String, Object> map=inspectionService.getporint(pointid);
			
			List<DictionarieValueModel> listDictionaryByDictCode = remoteSecurityService.listDictionaryByDictCode("BANK_ORG");
			String xian="";
			String xianyang="";
	    	StringBuffer sb = new StringBuffer();
	    	
	    	for (DictionarieValueModel e : listDictionaryByDictCode) {
	    		if("xian".equals(e.getDictDataKey())) {
	    			xian=e.getDictDataValue();
	    		}
	    		if("xianyang".equals(e.getDictDataKey())) {
	    			xianyang=e.getDictDataValue();
	    		}
			}
	    	java.util.HashMap<String, Object> map1  =new java.util.HashMap<>();
			
	    	if(map!=null){
	    		boolean  status= (boolean) map.get("status");
	    		String  code= map.get("code").toString();
	    		if(status){
	    			map1.put("pointtype", true);
	    		}else{
	    			map1.put("pointtype",false );
	    		}
	    		  
	    		if (code.indexOf(xian)!=-1){
	    			map1.put("cstype","xian" );
	    		}
                if (code.indexOf(xianyang)!=-1){
                	map1.put("cstype","xianyang" );
	    		}
	    	}else{
	    		
	    		java.util.HashMap<String, Object> mapp=inspectionService.getporintdate(pointid);
	    		
	    		if(mapp!=null){
	    			String  code= mapp.get("code").toString();
	    			 map1.put("pointtype",false );
	    			if (code.indexOf(xian)!=-1){
		    			map1.put("cstype","xian" );
		    		}else if (code.indexOf(xianyang)!=-1){
	                	map1.put("cstype","xianyang" );
		    		}
	    			
	    			
	    		}
	    		
	    		
	    		
	    		
	    		
	    	}
				
	        return CommonResponseUtil.success(map1);
	    }
	 
	 
	 
	 
	 
	 
	 
	 
	 
}
