package com.yeejoin.amos.bank.dao.repository;

import java.util.List;
import java.util.Map;

import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import com.yeejoin.amos.bank.dao.entity.Alarm;
import com.yeejoin.amos.op.core.jpa.IBaseRepository;

@Repository("iAlarmDao")
public interface IAlarmRepository extends IBaseRepository<Alarm, String> {

	@Query(value="select * from spc_alarm where query_column =?1 AND current_state in ('未确认未清除','已确认未清除','异常')",nativeQuery=true )
	public List<Alarm> selectbyqueryColumn(String type);
	
	@Query(value="select COUNT(*) value,spc_alarm.alarm_level name  from  spc_alarm where spc_alarm.org_code  like CONCAT(?1,'%' )  and spc_alarm.current_state in ('未确认未清除','已确认未清除','异常')  GROUP BY spc_alarm.alarm_level ",nativeQuery=true )
	public List<Object[]> countnum(String code);
	
}


