package com.yeejoin.amos.bank.remote.client;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.yeejoin.amos.component.feign.config.InnerInvokException;
import com.yeejoin.amos.op.core.common.response.CommonResponse;

/**
 * @Author: Xing Lei
 * @Description:
 * @Date: 2020-02-18 14:52
 */
@FeignClient(name = "AmosIot-42")
public interface DeviceRemoteClient {


    /**
     * 查询三维设备点
     */
    @RequestMapping(value = "/device/attr/equipments", method = RequestMethod.POST, consumes="application/json")
    Object selectEquipments(@RequestBody String params) throws InnerInvokException;

    /**
     * 根据型号查询设备点
     */
    @RequestMapping(value = "/device/listByOrgCodeAndModel", method = RequestMethod.GET)
    Object listByOrgCodeAndModel(@RequestParam(value = "orgCode", required = false) String orgCode, @RequestParam("model") String model) throws InnerInvokException;

    /**
     * 根据设备id查询数据详情
     */
    @RequestMapping(value = "/mericdata/equip/{id}", method = RequestMethod.GET)
    Object selectEquipById(@RequestParam(value = "id", required = false) String id) throws InnerInvokException;

    /**
     * 触发清除告警
     */
    @RequestMapping(value = "/xml/alarm", method = RequestMethod.GET)
    Object sendAlarm(@RequestParam(value = "xmlData", required = false) String xmlData) throws InnerInvokException;
    
    /**
     * 查询设备详情列表以及指标
     * @param equipmentId
     * @return
     * @throws InnerInvokException
     */
    @RequestMapping(value = "/device/cpbl/attr", method = RequestMethod.GET)
    CommonResponse  listDeviceAndDeviceCpblAttr(@RequestParam(value = "equipmentId",required = false)   Long equipmentId) throws InnerInvokException;

}
