package com.yeejoin.amos.bank.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.springframework.data.domain.Page;

import com.alibaba.fastjson.JSONArray;
import com.yeejoin.amos.bank.entity.DeviceRecord;
import com.yeejoin.amos.bank.param.PointParam;
import com.yeejoin.amos.component.feign.config.InnerInvokException;
import com.yeejoin.amos.spc.core.common.request.CommonPageable;
import com.yeejoin.amos.spc.core.common.response.Node3DVoResponse;

/**
 * 设备service
 *
 */
public interface IEquipmentService {

	JSONArray queryEquipmentById(Long id, String type, String token);

	Page<Object> queryEquipmentPortListById(Long id, CommonPageable commonPageable);

//	Page<Object> queryEquipmentWarnListById(String sourceId, CommonPageable commonPageable);

	List<Object> queryNetwoerkInterfaceById(Long id);

	ArrayList<Node3DVoResponse> queryEqui3dData(String orgCode);
	
	void syncDeviceList();
	
	List<DeviceRecord> selfDevice();
	
	Page queryEquimentRelation(CommonPageable commonPageable, String fname);
	
	List<PointParam> handleEquipmentsPointData (Long factorId) throws InnerInvokException;
	
	List<PointParam> handlePatrolPointData(Long factorId) throws InnerInvokException;
	
	Map<String, List> handlePointDatas(Long factorId) throws InnerInvokException;

}
