package com.yeejoin.amos.bank.task;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import com.yeejoin.amos.bank.service.IEquipmentService;

@Component
public class DeviceTask {
	private final Logger log = LoggerFactory.getLogger(DeviceTask.class);

	@Autowired
    private IEquipmentService equipmentService;
	
	/**
	 * 每天凌晨一点执行一次同步设备
	 */
	@Scheduled(cron="0 0 1 * * ?")
	public void taskOne() {
		log.debug("device scheduled start...");
		try {
			equipmentService.syncDeviceList();
		} catch (Exception e) {
			log.error("device scheduled fail..." + e.getMessage());
		}
		log.debug("device scheduled end...");
		
	}

}
