package com.yeejoin.amos.bank.webSocket;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import com.yeejoin.amos.op.core.common.response.CommonResponse;

@FeignClient(name = "AmosWebsocket",configuration={MultipartSupportConfig.class}, fallback=AmosWsClientFallback.class)
public interface AmosWsClient {

	@PostMapping("/generic/sendMessage")
    CommonResponse sendMessage(@RequestBody WebsocketParam param);
	
	@PostMapping("/generic/sendDataList")
    CommonResponse sendDataList(@RequestBody WebsocketListParam param);
	
}
