package com.yeejoin.amos.spc.business.controller;


import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.spc.business.rulemodel.ProtalDataRo;
import com.yeejoin.amos.spc.business.service.intfc.IBizMessageService;
import com.yeejoin.amos.spc.core.common.request.CommonPageable;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value = "/api/message")
@Api(tags="消息")
public class BizMessageController extends BaseController{


    @Autowired
    IBizMessageService iBizMessageService;

    @ApiOperation(httpMethod = "GET",value = "分页查询消息", notes = "分页查询消息")
    @RequestMapping(value = "/page", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse forPage(
            @ApiParam(value = "日期") @RequestParam(required = false)String  time,
            @ApiParam(value = "类型") @RequestParam(required = false)String  type,
            @ApiParam(value = "标题") @RequestParam(required = false)String  title,
                                    @RequestParam int pageNumber,
                                    @RequestParam  int pageSize
    ) {

        CommonPageable commonPageable = new CommonPageable(pageNumber,pageSize);
        return CommonResponseUtil.success(iBizMessageService.queryForPage(StringUtils.trimToNull(time), StringUtils.trimToNull(type), StringUtils.trimToNull(title),StringUtils.trimToNull( this.getOrgCode().split("_")[0]), commonPageable));
    }
       @SuppressWarnings("unused")
       @ApiOperation(value = "巡检点统计", notes = "首页统计")
       @PostMapping(value = "/mobile/getcountxd")
       public CommonResponse getcountxd(@RequestBody Map<String, String> maps) {
    	   String code="";
    	   if(!maps.isEmpty()){
    		   code=maps.get("code");
    	   }
    	   
           List<HashMap<String, Object>> list= iBizMessageService.getcountxd(code);
           List<HashMap<String, Object>> list2= iBizMessageService.getcountnum(code);
           List<HashMap<String, Object>> lista  =new ArrayList<>();
           if(list!=null&&list.size()>0){
           
           	if(list.size()==4){
           		  Map<String, Object> map =new HashMap<>();
                     if(list2!=null&&list2.size()>0){
                  	   map.put("total", list2.get(0).get("num"));
                     }
                    
                     map.put("data", list);
           		return CommonResponseUtil.success(map);
           	}else{
           for (int i = 1; i < 5; i++) {
           	HashMap<String, Object> map =new  HashMap<>();
           	
           	for (int j = 0; j < list.size(); j++) {
   				
           		if((i+"").equals(list.get(j).get("level")+"")){
           			
           			map= list.get(j);
           			continue;
           		}
   			}
           	
                	if(map.isEmpty()){
                		map.put("value", "0/0");
                		if(i==1){
                       	map.put("name", "一级风险");

                		}else if(i==2){
                       	map.put("name", "二级风险");

                		}else if(i==3){
                       	map.put("name", "三级风险");

                		}else{
                       	map.put("name", "四级风险");
   	
                		}
                   	map.put("level", i);	
                	}
           
           	
           	lista.add(map);
   		}
           	}
           }else{
           	
           	  for (int i = 1; i < 5; i++) {
                 	HashMap<String, Object> map =new  HashMap<>();
                      	if(map.isEmpty()){
                      		map.put("value", "0/0");
                      		if(i==1){
                             	map.put("name", "一级风险");

                      		}else if(i==2){
                             	map.put("name", "二级风险");

                      		}else if(i==3){
                             	map.put("name", "三级风险");

                      		}else{
                             	map.put("name", "四级风险");
         	
                      		}
                         	map.put("level", i);	
                      	}
                 
                 	
                 	lista.add(map);
         		}
           	
           }
           
          
                      
                      Map<String, Object> map =new HashMap<>();
                      if(list2!=null&&list2.size()>0){
                   	   map.put("total", list2.get(0).get("num"));
                      }
                     
                      map.put("data", lista);
           return CommonResponseUtil.success(map);
       }
}
