package com.yeejoin.amos.spc.business.dao.repository;

import java.util.List;

import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.yeejoin.amos.spc.dao.entity.SpcCameras;

@Repository("iSpcCameraDao")
public interface ISpcCameraDao extends BaseDao<SpcCameras, Long>{

	@Modifying
	@Transactional
	@Query(value="delete from spc_cameras where id in (?1)", nativeQuery = true)
	void deleteBatchByIds(List<Long> ids);
	
	@Query(value="select ca.* from spc_cameras ca right join spc_equipment_camera_bind ecb ON ecb.camera_id = ca.id WHERE ecb.equipment_id = ?1", nativeQuery = true)
	List<SpcCameras> getBingCamerasByEquipId(Long equipId);
}
