package com.yeejoin.amos.spc.business.dao.repository;

import java.util.List;

import org.springframework.stereotype.Repository;

import com.yeejoin.amos.spc.dao.entity.SpcEvaluateNorm;
@Repository("iSpcEvaluateNormDao")
public interface ISpcEvaluateNormDao extends BaseDao<SpcEvaluateNorm, Long>{
	
	/**
	 * 根据风险模型查找评价准则个数
	 * @param evaluateMethodId
	 * @return
	 */
	public int countByEvaluateModelId(Long evaluateModelId);
	
	/**
	 * 更具准则名称和风险模型id查询
	 * @param name
	 * @param evaluateModelId
	 * @return
	 */
	public List<SpcEvaluateNorm> findByNameAndEvaluateModelId(String name, Long evaluateModelId);

}
