package com.yeejoin.amos.spc.business.feign;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;

public class FeignBasicAuthRequestInterceptor implements RequestInterceptor {
    public FeignBasicAuthRequestInterceptor() {

    }

    @Override
    public void apply(RequestTemplate template) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            return;
        }
        ServletRequestAttributes attributes = (ServletRequestAttributes) requestAttributes;
        HttpServletRequest request = attributes.getRequest();
        /* Get token from header */
//        String authToken = request.getHeader("X-Access-Token");
//        /* If token not found get it from request parameter */
//        if (authToken == null) {
//            authToken = request.getParameter("token");
//        }
        //template.header("X-Access-Token", authToken);
        //设置header
        String token = request.getHeader("token");
        String product = request.getHeader("product");
        String appKey = request.getHeader("appKey");
        template.header("token", token);
        template.header("product", product);
        template.header("appKey", appKey);
    }

}
