package com.yeejoin.amos.spc.business.feign;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

import feign.Logger;
import feign.Request;

@Configuration
public class FeignConfiguration {
	
	public static int connectTimeOutMillis = 12000;//超时时间
    public static int readTimeOutMillis = 12000;


    @Bean
    public Request.Options options() {
        return new Request.Options(connectTimeOutMillis, readTimeOutMillis);
    }
    
	/**
     * 日志级别
     * @return
     */
    @Bean  
    @Primary
    Logger.Level feignLoggerLevel() {  
        return Logger.Level.FULL;  
    }

    /**
     * 创建Feign请求拦截器，在发送请求前设置认证的token,各个微服务将token设置到环境变量中来达到通用
     * @return
     */
    @Bean
    public FeignBasicAuthRequestInterceptor basicAuthRequestInterceptor() {
        return new FeignBasicAuthRequestInterceptor();
    }

}
