//package com.yeejoin.amos.spc.business.remote;
//
//import com.alibaba.fastjson.JSON;
//import com.alibaba.fastjson.JSONObject;
//import com.google.common.collect.Maps;
//import com.yeejoin.amos.spc.business.constants.FasConstant;
//import com.yeejoin.amos.spc.common.enums.WorkFlowUriEnum;
//import com.yeejoin.amos.spc.core.util.HttpUtil;
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//import org.springframework.beans.factory.annotation.Value;
//import org.springframework.stereotype.Service;
//import org.springframework.util.StringUtils;
//
//import java.util.Map;
//
//@Service("remoteWorkFlowService")
//public class RemoteWorkFlowService {
//
//    private final Logger logger = LoggerFactory.getLogger(RemoteWorkFlowService.class);
//
//    @Value("${params.work.flow.address}")
//    private String address;
//
//    private static final String success = "SUCCESS";
//
//    private static final String appKey = "8b193f7cb22c842b5a56e866c2e20dbf";
//
//    private String buildUrl(String address, WorkFlowUriEnum workFlowUriEnum, Map<String, String> map) {
//        String uri = workFlowUriEnum.getUri();
//        String params = workFlowUriEnum.getParams();
//        if (!StringUtils.isEmpty(params) && map != null) {
//            String[] paramsArr = params.split(",");
//            for (String param : paramsArr) {
//                uri = uri.replace("{" + param + "}", map.get(param));
//            }
//        }
//        return address + uri;
//    }
//
//    private JSONObject handleResult(String resultStr) {
//        if (resultStr == null) {
//            return null;
//        }
//        JSONObject json = JSON.parseObject(resultStr);
//        if (success.equals(json.getString("result"))) {
//            return json;
//        }
//        return null;
//    }
//
//    public JSONObject start(JSONObject body, String token) {
//        String url = buildUrl(address, WorkFlowUriEnum.启动流程, null);
//        Map<String, String> headerMap = Maps.newHashMap();
//        headerMap.put(FasConstant.TOKEN_KEY, token);
//        String requestBody = body.toJSONString();
//        String resultStr = HttpUtil.sendHttpPostJsonWithHeader(url, requestBody, headerMap);
//        logger.info("\r\n请求路径=======================>" + url + "\r\n请求参数=======================>" + requestBody + "\r\n返回参数=======================>" + resultStr);
//        return handleResult(resultStr);
//    }
//
//    public JSONObject startWithAppKey(JSONObject body) {
//        Map<String, String> map = Maps.newHashMap();
//        map.put("appKey", appKey);
//        String url = buildUrl(address, WorkFlowUriEnum.启动免登录流程, map);
//        String requestBody = body.toJSONString();
//        String resultStr = HttpUtil.sendHttpPostJson(url, requestBody);
//        logger.info("\r\n请求路径=======================>" + url + "\r\n请求参数=======================>" + requestBody + "\r\n返回参数=======================>" + resultStr);
//        return handleResult(resultStr);
//    }
//
////    public JSONObject excute(String taskId, String requestBody) {
////        Map<String, String> map = Maps.newHashMap();
////        map.put("taskId", taskId);
////        String url = buildUrl(address, WorkFlowUriEnum.执行流程, map);
////        String resultStr = HttpUtil.sendHttpPostJson(url, requestBody);
////        JSONObject json = handleResult(resultStr);
////        logger.info("\r\n请求路径=======================>" + url + "\r\n请求参数=======================>" + requestBody + "\r\n返回参数=======================>" + resultStr);
////        return json;
////    }
////
////    public JSONObject currentTask(String instanceId) {
////        Map<String, String> map = Maps.newHashMap();
////        map.put("instanceId", instanceId);
////        String url = buildUrl(address, WorkFlowUriEnum.当前节点, map);
////        String resultStr = HttpUtil.sendHttpGet(url);
////        JSONObject json = handleResult(resultStr);
////        logger.info("\r\n请求路径=======================>" + url + "\r\n返回参数=======================>" + resultStr);
////        if (json == null) {
////            return null;
////        }
////        JSONArray reviewContent = json.getJSONObject("dataList").getJSONArray("content");
////        if (reviewContent != null && reviewContent.size() > 0) {
////            return reviewContent.getJSONObject(0);
////        }
////        return null;
////    }
//
//}
