package com.yeejoin.amos.spc.business.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.assertj.core.util.Sets;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.op.core.common.query.DaoCriteria;
import com.yeejoin.amos.spc.business.dao.repository.ISpcIdentificationMethodDao;
import com.yeejoin.amos.spc.business.dao.repository.ISpcRiskFactorDao;
import com.yeejoin.amos.spc.business.dao.repository.ISpcRiskSourceDao;
import com.yeejoin.amos.spc.business.remote.RemoteSecurityService;
import com.yeejoin.amos.spc.business.service.intfc.ISpcIdentificationMethodService;
import com.yeejoin.amos.spc.core.common.request.CommonPageable;
import com.yeejoin.amos.spc.core.util.query.BaseQuerySpecification;
import com.yeejoin.amos.spc.dao.entity.SpcIdentificationMethod;
import com.yeejoin.amos.spc.exception.YeeException;

@Service("iIdentificationMethodService")
public class SpcIdentificationMethodServiceImpl implements ISpcIdentificationMethodService {

    @Autowired
    ISpcIdentificationMethodDao iIdentificationMethodDao;

    @Autowired
    ISpcRiskFactorDao iSpcRiskFactorDao;
    
    @Autowired
    ISpcRiskSourceDao iSpcRiskSourceDao;
    
    @Autowired
    private RemoteSecurityService remoteSecurityService;

    @Override
    public SpcIdentificationMethod createIdentificationMethod(SpcIdentificationMethod identiMethodEntity) {
    	iIdentificationMethodDao.save(identiMethodEntity);
		return identiMethodEntity;
    }

    @Override
    public SpcIdentificationMethod updateIdentificationMethod(SpcIdentificationMethod identiMethodEntity) {
        SpcIdentificationMethod entity = iIdentificationMethodDao.findById(identiMethodEntity.getId()).get();
        BeanUtils.copyProperties(identiMethodEntity, entity);
        iIdentificationMethodDao.save(entity);
        return entity;
    }

    @Transactional
    @Override
    public List<Long> deleteIdenificationMethodById(List<Long> ids) {
    	//在使用中的风险辨识方法不能删除
    	List<Long> removedIds = new ArrayList<>();
    	List<String> methodNames = new ArrayList<>();
    	for (Long id : ids) {    		
    		int count1 = iSpcRiskFactorDao.countByIdentificationMethodId(id);
    		int count2 = iSpcRiskSourceDao.countByIdentificationMethodId(id);
    		if ((count1 + count2) > 0) {
    			removedIds.add(id);
    			if (null != iIdentificationMethodDao.findById(id).get()) {    				
    				methodNames.add(iIdentificationMethodDao.findById(id).get().getName());
    			}
    		}
    	}
    	if (methodNames.size() > 0) {
    		throw new YeeException("辨识方法【" + Joiner.on(",").join(methodNames) + "】在使用中，删除失败！");
    	}
    	ids.removeAll(removedIds);
        iIdentificationMethodDao.deleteByIds(ids);
        return ids;
    }

    @Override
    public Page<SpcIdentificationMethod> queryIdentificationMethodByPage(List<DaoCriteria> criterias,
                                                                         CommonPageable commonPageable) {
        BaseQuerySpecification<SpcIdentificationMethod> spec = new BaseQuerySpecification<>(criterias);
        Sort sort = new Sort(Sort.Direction.DESC,"id");
        commonPageable.setSort(sort);
        Page<SpcIdentificationMethod> identificationMethodPage = iIdentificationMethodDao.findAll(spec, commonPageable);
        List<SpcIdentificationMethod> list = identificationMethodPage.getContent();
        if (!CollectionUtils.isEmpty(list)) {
            List<String> userIds = Lists.transform(list, SpcIdentificationMethod::getCreatorId);
            Set<String> userIdSets = Sets.newHashSet(userIds);
            userIdSets.remove(null);
            List<AgencyUserModel> AgencyUserModels = remoteSecurityService.listUserByUserIds(Joiner.on(",").join(userIdSets));
            Map<String, AgencyUserModel> AgencyUserModelMap = Maps.uniqueIndex(AgencyUserModels, AgencyUserModel::getUserId);
            list.forEach(e -> {
                AgencyUserModel AgencyUserModel = AgencyUserModelMap.get(e.getCreatorId());
                if (AgencyUserModel != null) {
                    e.setCreateUserName(AgencyUserModel.getRealName());
                }
            });
        }
        return identificationMethodPage;
    }

    @Override
    public SpcIdentificationMethod queryIdentificationMethodDetailById(Long id) {
        return iIdentificationMethodDao.findById(id).get();
    }

    @Override
    public List<SpcIdentificationMethod> queryAllIdentificationMethod(List<DaoCriteria> criterias) {
        BaseQuerySpecification<SpcIdentificationMethod> spec = new BaseQuerySpecification<>(criterias);
        return iIdentificationMethodDao.findAll(spec);
    }

	@Override
	public List<SpcIdentificationMethod> queryIdentificationMethodByName(String name) {
		return iIdentificationMethodDao.findByName(name);
	}

}
