package com.yeejoin.amos.spc.business.service.impl;

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.assertj.core.util.Sets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.spc.business.dao.mapper.MajorHazardInstallationMapper;
import com.yeejoin.amos.spc.business.dao.repository.ISpcMajorHazardInstallationDao;
import com.yeejoin.amos.spc.business.param.PageParam;
import com.yeejoin.amos.spc.business.remote.RemoteSecurityService;
import com.yeejoin.amos.spc.business.service.intfc.ISpcMajorHazardInstallationService;
import com.yeejoin.amos.spc.dao.entity.SpcMajorHazardInstallation;

@Service("iSpcMajorHazardInstallationService")
public class SpcMajorHazardInstallationServiceImpl implements ISpcMajorHazardInstallationService {

	@Autowired
	private RemoteSecurityService remoteSecurityService;
	
	@Autowired
	private MajorHazardInstallationMapper majorHazardInstallationMapper;
	
	@Autowired
	private ISpcMajorHazardInstallationDao iSpcMajorHazardInstallationDao;
	
	@Override
	public SpcMajorHazardInstallation save(SpcMajorHazardInstallation spcMajorHazardInstallation) {
		iSpcMajorHazardInstallationDao.save(spcMajorHazardInstallation);
		return spcMajorHazardInstallation;
	}

	@Transactional
	@Override
	public void delete(List<Long> ids) {
		iSpcMajorHazardInstallationDao.deleteByIds(ids);
	}

	@Override
	public SpcMajorHazardInstallation getMajorHazardInstallationDetailById(Long id) {
		return iSpcMajorHazardInstallationDao.findById(id).get();
		
	}

	@Override
	public Page<List<SpcMajorHazardInstallation>> queryMajorHazardInstallationByPage(PageParam<String, Object> param) {
		if (null != param.get("pageNumber") && null != param.get("pageSize")) {
			param.setPageNumber(Integer.parseInt(String.valueOf(param.get("pageNumber"))));
			param.setPageSize(Integer.parseInt(String.valueOf(param.get("pageSize"))));
			param.put("offset", param.getOffset());
		} else {
			param.put("pageSize", param.getPageSize());
			param.put("offset", param.getOffset());
		}
		List<SpcMajorHazardInstallation> list = majorHazardInstallationMapper.listMajorHazardInstallationByPage(param);
		Long total = majorHazardInstallationMapper.countByParam(param);
		if (!CollectionUtils.isEmpty(list)) {
			Set<String> userIdSets = Sets.newHashSet();
			
			list.forEach(e -> {
				userIdSets.add(e.getCreatorId());
				userIdSets.add(e.getIdentificationUserId());
			});
			userIdSets.remove(null);
			userIdSets.remove("");
			List<AgencyUserModel> AgencyUserModels = remoteSecurityService.listUserByUserIds(Joiner.on(",").join(userIdSets));
			Map<String, AgencyUserModel> AgencyUserModelMap = Maps.uniqueIndex(AgencyUserModels, AgencyUserModel::getUserId);
			
			list.forEach(e -> {
				AgencyUserModel AgencyUserModel = AgencyUserModelMap.get(e.getCreatorId());
				if (AgencyUserModel != null) {
					e.setCreateUserName(AgencyUserModel.getRealName());
				}
				AgencyUserModel identificationAgencyUserModel = AgencyUserModelMap.get(e.getIdentificationUserId());
				if (identificationAgencyUserModel != null) {
					e.setIdentificationUserName(identificationAgencyUserModel.getRealName());
				}
			});
		}
		return new PageImpl(list, param, total);
	}

}
