package com.yeejoin.amos.spc.business.service.intfc;

import com.yeejoin.amos.op.core.common.query.DaoCriteria;
import com.yeejoin.amos.spc.core.common.request.CommonPageable;
import com.yeejoin.amos.spc.dao.entity.SpcCameras;
import com.yeejoin.amos.spc.dao.entity.SpcEquipment;
import org.springframework.data.domain.Page;

import java.util.List;
import java.util.Map;

;

public interface ISpcEquipmentService {

    /**
     * 保存设备设施
     *
     * @return
     */
    SpcEquipment saveEquipment(SpcEquipment imParam);

    /**
     * 根据ID删除设备设施
     *
     * @param ids
     * @return
     */
    List<Long> deleteEquipmentById(List<Long> ids);

    /**
     * 分页查询设备设施
     *
     * @param criterias
     * @param commonPageable
     * @return
     */
    Page<SpcEquipment> queryEquipmentByPage(List<DaoCriteria> criterias, CommonPageable commonPageable);

    /**
     * 根据ID查询设备设施详情
     *
     * @param id
     * @return
     */
    SpcEquipment queryEquipmentDetailById(Long id);

    /**
     * 绑定摄像机
     *
     * @param equipId
     * @param ids     摄像机ID
     */
    void bindCamera(Long equipId, String[] ids);

    /**
     * 删除绑定摄像机
     *
     * @param equipId
     * @param ids     摄像机ID
     */
    void unBindCamera(Long equipId, String[] ids);

    List<Map<String, Object>> listOptionByCondition(Long regionId, Long departmentId, String workshopSection, String name);
    
    /**
     * 根据设备id获取设备绑定摄像头
     * @param equipId
     * @return
     */
    List<SpcCameras> getBingCamerasByEquipId(Long equipId);
}
