package com.yeejoin.amos.spc.business.service.intfc;

import java.util.List;

import org.springframework.data.domain.Page;

import com.yeejoin.amos.op.core.common.query.DaoCriteria;
import com.yeejoin.amos.spc.core.common.request.CommonPageable;
import com.yeejoin.amos.spc.dao.entity.SpcIdentificationMethod;

public interface ISpcIdentificationMethodService {
	
	/**
	 * 新增风险辨识方法
	 * 
	 * @return
	 */
	SpcIdentificationMethod createIdentificationMethod(SpcIdentificationMethod imParam);
	
	/**
	 * 更新风险辨识方法
	 * 
	 * @return
	 */
	SpcIdentificationMethod updateIdentificationMethod(SpcIdentificationMethod imParam);
	
	/**
	 * 根据ID删除风险辨识方法
	 * 
	 * @param ids
	 * @return
	 */
	List<Long> deleteIdenificationMethodById(List<Long> ids);
	
	/**
	 * 分页查询风险辨识方法
	 * 
	 * @param criterias
	 * @param commonPageable
	 * @return
	 */
	Page<SpcIdentificationMethod> queryIdentificationMethodByPage(List<DaoCriteria> criterias, CommonPageable commonPageable);
	
	/**
	 * 根据ID查询风险辨识方法详情
	 * 
	 * @param id
	 * @return
	 */
	SpcIdentificationMethod queryIdentificationMethodDetailById(Long id);
	
	/**
	 * 查询所有风险辨识方法
	 * 
	 * @return
	 */
	List<SpcIdentificationMethod> queryAllIdentificationMethod(List<DaoCriteria> criterias);
	
	/**
	 * 根据名称查询
	 * @param name
	 */
	List<SpcIdentificationMethod> queryIdentificationMethodByName(String name);
}
