package com.yeejoin.amos.spc.core.util;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

import com.yeejoin.amos.spc.business.service.intfc.ISpcRiskSourceService;

public class TcpProcessor implements Runnable {

    private static final String equipId = "1159";

    private static final long wait_time = 25*1000;

    private static long time = 0L;

    public static Map<Commond, TcpProcessor> processorMap = new HashMap<>();


    private OutputStream outputStream;
    private Commond commond;
    private ISpcRiskSourceService spcRiskSourceService;

    public TcpProcessor(OutputStream outputStream, Commond commond,ISpcRiskSourceService spcRiskSourceService) {
        this.outputStream = outputStream;
        this.commond = commond;
        this.spcRiskSourceService = spcRiskSourceService;
    }


    public static TcpProcessor getInstance(OutputStream outputStream, Commond commond, ISpcRiskSourceService spcRiskSourceService) {
        TcpProcessor processor = processorMap.get(commond);
        if (processor == null) {
            processor = new TcpProcessor(outputStream, commond,spcRiskSourceService);
            processorMap.put(commond, processor);
        }
        return processor;
    }

    public static TcpProcessor getInstance(OutputStream outputStream, Commond commond) {
        TcpProcessor processor = processorMap.get(commond);
        if (processor == null) {
            processor = new TcpProcessor(outputStream, commond,null);
            processorMap.put(commond, processor);
        }
        return processor;
    }


    @Override
    public void run() {

        try
        {

            if(System.currentTimeMillis() - time <  wait_time)
                Thread.sleep(wait_time);

            switch (commond) {
                case alarm_is_send:
                    // TODO 处理告警
                    spcRiskSourceService.processFireEqumtData(equipId);
                    break;
                case reset:
                case shutdown:
                case emergency:
                case risk_control:
                case hidden_trouble_solution:
                    outputStream.write(commond.commondStr.getBytes());
                    outputStream.flush();
                    break;
            }

            time = System.currentTimeMillis();
        }catch (Exception e)
        {
            e.printStackTrace();
        }


    }

    enum Commond {

        alarm_is_send("0010001", "告警发送"),//告警发送
        risk_control("0010010", "风险管控"),//风险管控,
        hidden_trouble_solution("0010011", "隐患治理"),//隐患治理,
        emergency("0010100", "应急"),//应急,
        shutdown("0010101", "停机"),//停机,
        reset("0000000", "复位");//复位;


        private String desc;
        private String commondStr;

        Commond(String commondStr, String desc) {
            this.desc = desc;
            this.commondStr = commondStr;
        }

        public static Commond getByCommondStr(String commondStr) {
            Commond commond = null;
            for (Commond cmd : Commond.values())
                if (cmd.commondStr.equals(commondStr))
                    commond = cmd;
            return commond;
        }
    }

}
