package com.yeejoin.amos.bank;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

import com.yeejoin.amos.op.core.entity.BusinessEntity;

/**
 * 拓扑图连线
 * @author zhangzhihui
 *
 */
@Entity
@Table(name = "b_topography_line")
public class TopographyLine extends BusinessEntity{

	/**
     * id
     */
    @Id
    @GeneratedValue(generator = "uuid")
    @GenericGenerator(name = "uuid", strategy = "uuid2")
    @Column(name = "id", nullable = false, length = 36)
    protected String id;
	/**
     * 
     */
    @Column(name = "`from`", columnDefinition = "varchar(32) COMMENT '起点'")
    private String from;
    /**
     * 
     */
    @Column(name = "`to`", columnDefinition = "varchar(32) COMMENT '终点'")
    private String to;
    /**
     * 
     */
    @Column(name = "treeid", columnDefinition = "varchar(32) COMMENT '树id'")
    private String treeid;
    /**
     * 
     */
    @Column(name = "tree_node_id", columnDefinition = "varchar(32) COMMENT '树节点id'")
    private String treeNodeId;
    /**
     * 
     */
    @Column(name = "clickable", columnDefinition = "bit COMMENT '可点击'")
    private Boolean clickable;
    /**
     * 
     */
    @Column(name = "state", columnDefinition = "int COMMENT '异常状态'")
    private int state;
    /**
     * 
     */
    @Column(name = "number", columnDefinition = "int COMMENT '异常数量'")
    private Integer number;
    /**
     * 
     */
    @Column(name = "type", columnDefinition = "int COMMENT '类型：1-网络拓扑图，2-PAMS'")
    private Integer type;
    /**
     * 
     */
    @Column(name = "has_arrow", columnDefinition = "bit COMMENT '有箭头'")
    private Boolean hasArrow;
    /**
     * 
     */
    @Column(name = "from_port", columnDefinition = "varchar(32) COMMENT '起点位置'")
    private String fromPort;
    /**
     * 
     */
    @Column(name = "to_port", columnDefinition = "varchar(32) COMMENT '终点位置'")
    private String toPort;
    /**
     * 
     */
    @Column(name = "is_dash", columnDefinition = "bit COMMENT '是虚线'")
    private Boolean isDash;
    /**
     * 
     */
    @Column(name = "line_color", columnDefinition = "int COMMENT '线颜色'")
    private Integer lineColor;
    
    
    
    @Column(name = "org_code", columnDefinition = "varchar(255) COMMENT '单位'")
  	private String orgCode;
  	
  	public String getOrgCode() {
  		return orgCode;
  	}

  	public void setOrgCode(String orgCode) {
  		this.orgCode = orgCode;
  	}
      
    
    
	public Integer getLineColor() {
		return lineColor;
	}
	public void setLineColor(Integer lineColor) {
		this.lineColor = lineColor;
	}
	public Integer getType() {
		return type;
	}
	public void setType(Integer type) {
		this.type = type;
	}
	public String getFrom() {
		return from;
	}
	public void setFrom(String from) {
		this.from = from;
	}
	public String getTo() {
		return to;
	}
	public void setTo(String to) {
		this.to = to;
	}
	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}
	public String getTreeid() {
		return treeid;
	}
	public void setTreeid(String treeid) {
		this.treeid = treeid;
	}
	public Boolean getClickable() {
		return clickable;
	}
	public void setClickable(Boolean clickable) {
		this.clickable = clickable;
	}
	public String getTreeNodeId() {
		return treeNodeId;
	}
	public void setTreeNodeId(String treeNodeId) {
		this.treeNodeId = treeNodeId;
	}
	public int getState() {
		return state;
	}
	public void setState(int state) {
		this.state = state;
	}
	public Integer getNumber() {
		return number;
	}
	public void setNumber(Integer number) {
		this.number = number;
	}
	public Boolean getHasArrow() {
		return hasArrow;
	}
	public void setHasArrow(Boolean hasArrow) {
		this.hasArrow = hasArrow;
	}
	public String getFromPort() {
		return fromPort;
	}
	public void setFromPort(String fromPort) {
		this.fromPort = fromPort;
	}
	public String getToPort() {
		return toPort;
	}
	public void setToPort(String toPort) {
		this.toPort = toPort;
	}
	public Boolean getIsDash() {
		return isDash;
	}
	public void setIsDash(Boolean isDash) {
		this.isDash = isDash;
	}
}
