package com.yeejoin.amos.bank.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.hibernate.annotations.Index;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@MappedSuperclass
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "createId", "createDate", 
		"updateId", "updateDate", "recordState","creater","updater"})
public class BaseEntity implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = -2645944726831647278L;
	@Id
	@GeneratedValue(strategy=GenerationType.IDENTITY)
	@Column(name = "id",nullable=true)
	private Long id;
	@Column(name = "creater", columnDefinition="varchar(255) COMMENT '创建者'")
	private String creater;
	@Column(name = "create_date", columnDefinition="datetime COMMENT '创建时间'")
	private Date createDate;
	@Column(name = "updater", columnDefinition="varchar(255) COMMENT '修改者'")
	private String updater;
	@Column(name = "update_date", columnDefinition="datetime COMMENT '修改时间'")
	private Date updateDate;


	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}

	public Date getCreateDate() {
		return createDate;
	}
	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}

	public Date getUpdateDate() {
		return updateDate;
	}
	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}

	public String getCreater() {
		return creater;
	}
	public void setCreater(String creater) {
		this.creater = creater;
	}
	public String getUpdater() {
		return updater;
	}
	public void setUpdater(String updater) {
		this.updater = updater;
	}
}
