package com.yeejoin.amos.spc.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 摄像头类型
 * @author maoying
 *
 */
public enum CamerasEnum {
	// 枪型 半球 筒刑 球型 一体化！
	gun("枪型","01"),
	Hemispheric("半球","02"),
	cylinder("筒型","03"),
	ball("球型","04");
	/**
	 * 名称，描述
	 */
	private String name;
	/**
	 * 编码
	 */
	private String code;
	
	private CamerasEnum(String name,String code){
		this.name = name;
		this.code = code;
	}
	
	public static CamerasEnum getEnum(String code) {
		CamerasEnum instance = null;
		for(CamerasEnum type: CamerasEnum.values()) {
			if (type.getCode().equals(code)) {
				instance = type;
				break;
			}
		}
		
		return instance;
	}
	
	public static String getEnumName(String code) {
		String name = "";
		for(CamerasEnum type: CamerasEnum.values()) {
			if (type.getCode().equals(code)) {
				name = type.getName();
				break;
			}
		}
		
		return name;
	}
	
	public static List<Map<String,String>> getEnumList() {
		List<Map<String,String>> list = new ArrayList<>();
		for(CamerasEnum e : CamerasEnum.values()) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("code", e.getCode());
			map.put("name", e.getName());
			list.add(map);
		}
		return list;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}
}
