package com.yeejoin.amos.spc.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 管控措施类别
 * @author maoying
 *
 */
public enum ControlMeasuresCategoryEnum {
	engineering("工程技术措施","01"),
	manage("管理措施","02"),
	individualProtection("个体防护措施","03"),
	emergencyDisposal("应急处置措施","04"),
	education("教育培训措施","05");
	/**
	 * 名称，描述
	 */
	private String name;
	/**
	 * 编码
	 */
	private String code;
	
	private ControlMeasuresCategoryEnum(String name,String code){
		this.name = name;
		this.code = code;
	}
	
	public static ControlMeasuresCategoryEnum getEnum(String code) {
		ControlMeasuresCategoryEnum instance = null;
		for(ControlMeasuresCategoryEnum type: ControlMeasuresCategoryEnum.values()) {
			if (type.getCode().equals(code)) {
				instance = type;
				break;
			}
		}
		
		return instance;
	}
	
	public static List<Map<String,String>> getEnumList() {
		List<Map<String,String>> list = new ArrayList<>();
		for(ControlMeasuresCategoryEnum e : ControlMeasuresCategoryEnum.values()) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("code", e.getCode());
			map.put("name", e.getName());
			list.add(map);
		}
		return list;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}
}
