package com.yeejoin.amos.spc.common.enums;

public enum WorkFlowActionTypeEnum {

    通过("通过", 1),
    终止流程("终止流程", 3);

    private String desc;

    private Integer actionType;

    WorkFlowActionTypeEnum(String desc, Integer actionType) {
        this.desc = desc;
        this.actionType = actionType;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Integer getActionType() {
        return actionType;
    }

    public void setActionType(Integer actionType) {
        this.actionType = actionType;
    }

    public static WorkFlowActionTypeEnum getByActionType(Integer actionType) {
        for (WorkFlowActionTypeEnum e : WorkFlowActionTypeEnum.values()) {
            if (actionType.equals(e.actionType)) {
                return e;
            }
        }
        return null;
    }
}