package com.yeejoin.amos.spc.dao.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import java.math.BigInteger;
import java.util.Date;


/**
 * The persistent class for the spc_risk_judgment_fill_record database table.
 */
@Entity
@Table(name = "spc_risk_judgment_fill_record")
@NamedQuery(name = "SpcRiskJudgmentFillRecord.findAll", query = "SELECT s FROM SpcRiskJudgmentFillRecord s")
public class SpcRiskJudgmentFillRecord extends BasicEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 是否删除（0：否；1：是）
     */
    private byte deleted;

    /**
     * 填写结果
     */
    @Column(name = "input_result")
    private String inputResult;

    /**
     * 风险研判项编号
     */
    @Column(name = "item_id")
    private BigInteger itemId;

    /**
     * 拍照结果
     */
    @Column(name = "photo_result")
    private String photoResult;

    /**
     * 备注结果
     */
    @Column(name = "remark_result")
    private String remarkResult;

    /**
     * 选择结果
     */
    @Column(name = "select_result")
    private String selectResult;

    /**
     * 风险研判任务编号
     */
    @Column(name = "task_id")
    private BigInteger taskId;

    @Column(name = "item_finish")
    private Integer itemFinish;

    /**
     * 组织机构编号
     */
    @Column(name = "org_code")
    private String orgCode;

    /**
     * 记录修改时间
     */
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_date")
    private Date updateDate;

    public SpcRiskJudgmentFillRecord() {
    }

    public byte getDeleted() {
        return this.deleted;
    }

    public void setDeleted(byte deleted) {
        this.deleted = deleted;
    }

    public String getInputResult() {
        return this.inputResult;
    }

    public void setInputResult(String inputResult) {
        this.inputResult = inputResult;
    }

    public BigInteger getItemId() {
        return this.itemId;
    }

    public void setItemId(BigInteger itemId) {
        this.itemId = itemId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getPhotoResult() {
        return this.photoResult;
    }

    public void setPhotoResult(String photoResult) {
        this.photoResult = photoResult;
    }

    public String getRemarkResult() {
        return this.remarkResult;
    }

    public void setRemarkResult(String remarkResult) {
        this.remarkResult = remarkResult;
    }

    public String getSelectResult() {
        return this.selectResult;
    }

    public void setSelectResult(String selectResult) {
        this.selectResult = selectResult;
    }

    public BigInteger getTaskId() {
        return this.taskId;
    }

    public void setTaskId(BigInteger taskId) {
        this.taskId = taskId;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public Integer getItemFinish() {
        return itemFinish;
    }

    public void setItemFinish(Integer itemFinish) {
        this.itemFinish = itemFinish;
    }
}