package com.yeejoin.amos.spc.dao.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;


/**
 * The persistent class for the spc_taskwork_measures database table.
 * 
 */
@Entity
@Table(name="spc_taskwork_measures")
@NamedQuery(name="SpcTaskworkMeasure.findAll", query="SELECT s FROM SpcTaskworkMeasure s")
public class SpcTaskworkMeasure extends BasicEntity  {
	private static final long serialVersionUID = 1L;

	/**
	 * 执行状态:0-未执行；1-已执行 
	 */
	@Column(name="execute_state")
	private Integer executeState = 0;

	/**
	 * 控制措施内容id
	 */
	@Column(name="measures_content_id")
	private Long measuresContentId;

	/**
	 * 备注
	 */
	private String remerk;

	/**
	 * 危险因素管控措施id
	 */
	@Column(name="risk_factors_cm_id")
	private Long riskFactorsCmId;

	/**
	 * 作业活动步骤编号id
	 */
	@Column(name="taskwork_content_id")
	private Long taskworkContentId;

	/**
	 * 违章状态：0-未确认；1-无违章；2-一般违章；3-严重违章
	 */
	@Column(name="violate_state")
	private Integer violateState = 0;

	public SpcTaskworkMeasure() {
	}

	public Integer getExecuteState() {
		return this.executeState;
	}

	public void setExecuteState(Integer executeState) {
		this.executeState = executeState;
	}

	public Long getMeasuresContentId() {
		return this.measuresContentId;
	}

	public void setMeasuresContentId(Long measuresContentId) {
		this.measuresContentId = measuresContentId;
	}

	public String getRemerk() {
		return this.remerk;
	}

	public void setRemerk(String remerk) {
		this.remerk = remerk;
	}

	public Long getRiskFactorsCmId() {
		return this.riskFactorsCmId;
	}

	public void setRiskFactorsCmId(Long riskFactorsCmId) {
		this.riskFactorsCmId = riskFactorsCmId;
	}

	public Long getTaskworkContentId() {
		return this.taskworkContentId;
	}

	public void setTaskworkContentId(Long taskworkContentId) {
		this.taskworkContentId = taskworkContentId;
	}

	public Integer getViolateState() {
		return this.violateState;
	}

	public void setViolateState(Integer violateState) {
		this.violateState = violateState;
	}

}