package com.yeejoin.amos.bank.config;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.yeejoin.amos.bank.dao.mapper.AlarmMapper;
import com.yeejoin.amos.bank.remote.AmosWsService;
import com.yeejoin.amos.bank.utils.DateTimeKit;
import org.apache.log4j.Logger;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.component.emq.EmqKeeper;
import org.typroject.tyboot.component.emq.EmqxListener;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.bank.TopographyNode;
import com.yeejoin.amos.bank.common.enums.AlarmPointTypeEnum;
import com.yeejoin.amos.bank.common.enums.DevicePointEnum;
import com.yeejoin.amos.bank.common.enums.DeviceStatusEnum;
import com.yeejoin.amos.bank.dao.IDeviceRecord;
import com.yeejoin.amos.bank.dao.entity.Alarm;
import com.yeejoin.amos.bank.dao.entity.AlarmPoint;
import com.yeejoin.amos.bank.dao.repository.IAlarmRepository;
import com.yeejoin.amos.bank.dao.repository.ITopographyLineRepository;
import com.yeejoin.amos.bank.entity.DeviceRecord;
import com.yeejoin.amos.bank.entity.EquipmentQualityVo;
import com.yeejoin.amos.bank.remote.client.RiskModelRemoteClient;
import com.yeejoin.amos.bank.service.IAlarmPointService;
import com.yeejoin.amos.bank.service.IAlarmService;
import com.yeejoin.amos.component.feign.config.InnerInvokException;
import com.yeejoin.amos.spc.business.dao.mapper.EquipmentMapper;
import com.yeejoin.amos.spc.business.remote.RemoteWebSocketServer;
import com.yeejoin.amos.spc.core.util.StringUtil;


import static com.yeejoin.amos.bank.constants.AlarmConstant.*;

@Component
public class SelfSupportListener extends EmqxListener implements InitializingBean {

    private static final Logger logger = Logger.getLogger(SelfSupportListener.class);

    @Autowired
    private EmqKeeper emqKeeper;

    @Autowired
    EquipmentMapper equipmentMapper;

    @Autowired
    RiskModelRemoteClient riskModelRemoteClient;

    @Autowired
    IDeviceRecord iDeviceRecord;

    @Autowired
    ITopographyLineRepository nodeDao;

    @Autowired
    private RemoteWebSocketServer webSocketServer;
    @Autowired
    private IAlarmPointService alarmPointService;

    @Autowired
    private IAlarmService alarmService;
    @Autowired
    private IAlarmRepository iAlarmDao;

    @Autowired
    private AmosWsService amosWsService;

    @Autowired
    private AlarmMapper alarmMapper;

    /**
     * 监听主题
     */
    @Override
    public void afterPropertiesSet() throws Exception {
        emqKeeper.subscript(CommTopic.SUPPORT_PING.getTopic(), 2, this);
    }

    /**
     * 接收主题下的消息
     */
    @Override
    public void processMessage(String s, MqttMessage mqttMessage) throws Exception {

        blueprintMsgtransfer(mqttMessage);
    }


    /**
     * 消息处理
     *
     * @param mqttMessage
     */
    private void blueprintMsgtransfer(MqttMessage mqttMessage) {

        try {

            String jsonStr = new String(mqttMessage.getPayload());
            System.out.println("----supprtmqtt received--jsonStr:" + jsonStr);
//            logger.error("----supprtmqtt received--jsonStr",jsonStr);
            JSONObject parseObject = JSON.parseObject(jsonStr);
            //logger.info("----supprtmqtt received sucess",parseObject);
            System.out.println("----supprtmqtt received sucess :" + parseObject);
            Long eqpId = parseObject.getLong("eqpId");
            JSONArray jsonArray = parseObject.getJSONArray("metricDatas");
            JSONArray eqpConfigMap = parseObject.getJSONArray("eqpConfigMap");
            //获取ip
            String ipAddress = getIpAddress(eqpConfigMap);
            //楼层
            String lou = getIpAddress1(eqpConfigMap, "所属楼层");
            //3为坐标
            String sanwei = getIpAddress1(eqpConfigMap, "三维位置");

            String eqpName = parseObject.getString("eqpName");
            //orgcode
            String orgCode1 = parseObject.getString("orgCode");

            if (ObjectUtils.isEmpty(jsonArray)) {
                return;
            }
            //告警信息
            String metricKey = "";
            //默认状态为正常           
            int statusByName = 0;
//          jsonArray.forEach(e -> {
            for (Object e : jsonArray) {
                JSONObject object = (JSONObject) e;
                String string = object.getString("metricJson");
                metricKey = object.getString("metricKey");
                if (!StringUtil.isNotEmpty(string)) {
                    return;
                }
                logger.debug("---------shudu--string" +  string);
                System.out.println("----supprtmqtt chuli recording : " + string);
                //{\"maxTime\":\"1\",\"packetLossRate\":\"0\",\"avgTime\":\"0\",\"minTime\":\"0\",\"发包数\":\"\",\"icmpPackSize\":\"32\",\"status\":\"通\"}
                JSONObject metricJson = JSONObject.parseObject(string);

                for (Map.Entry entry : metricJson.entrySet()) {
                    // 指标名
                    System.out.println("----start chuli device state : " + entry);
                    String remark = entry.getKey().toString();
                    String statusName = entry.getValue().toString();

                    if (remark.equals("status")) {
                        DeviceRecord record = new DeviceRecord();
                        record.setDeviceId(eqpId);
                        statusByName = DeviceStatusEnum.getStatusByName(statusName);
                        record.setDeviceStatus(statusByName);
                        record.setMetricData(string);
                        record.setName(eqpName + " " + ipAddress);
                        iDeviceRecord.save(record);
                        TopographyNode node = equipmentMapper.queryNodeBySourceId(String.valueOf(eqpId));
                        logger.debug("start delete one hour deivceRecord");
                        equipmentMapper.deleteOneHourNormal();
                        logger.debug("end delete one hour deivceRecord");

                        //触发风险合格不合格
                        EquipmentQualityVo queryEquipmentPoint = equipmentMapper.queryEquipmentPoint(eqpId, remark);
                        Long equipmentsPointId = queryEquipmentPoint.getId();
                        List<Long> riskFactorId = equipmentMapper.judgeEquipmentExists(equipmentsPointId);
                        Integer value = 0;
                        if ("不通".equals(statusName)) {
                            value = DevicePointEnum.getValue("异常");
                            equipmentMapper.updateEquipmentPointStatus(value, queryEquipmentPoint.getId());
                        } else {
                            value = DevicePointEnum.getValue("正常");
                            equipmentMapper.updateEquipmentPointStatus(value, queryEquipmentPoint.getId());
                        }
                        //修改rpn值
                        for (int j = 0; j < riskFactorId.size(); j++) {
                            try {
                                riskModelRemoteClient.updateEquipmentAlarmData(riskFactorId.get(j),eqpName,value);
                                System.out.println("----udpate riskFactor sucess");
                            } catch (InnerInvokException e1) {
                                logger.error("update rpn fail " + e1.getMessage());
                            }
                        }

                        if (null != node) {
                            node.setNumber(statusByName);
                            node.setState(statusByName);
                            equipmentMapper.updateNodeState(node);
                            String nodeDetail = (statusByName == 0 ? "[{\"name\":\"通信状态\",\"value\":\"正常\"}]" : "[{\"name\":\"通信状态\",\"value\":\"异常\"}]");
                            equipmentMapper.updateNodeDetail(node.getId(), nodeDetail);
                            try {
                                webSocketServer.sendMessage("refresh", "self");
                            } catch (Exception e1) {
                                logger.error("webSocketServer send self! ");
                            }
                        }
                    }
                }
            }
            ;
//            });


            //增加报警           
            List<AlarmPoint> alarmPoint = alarmPointService.selectPointTypeAndPointId(AlarmPointTypeEnum.设备.getCode(), eqpId);
            if (alarmPoint != null && alarmPoint.size() > 0) {
                //存在报警，判断当前状态是不是合格，合格则删除上次的报警
                if (statusByName == 0) {
                    //删除告警
                    alarmPointService.delete(alarmPoint.get(0));
                    amosWsService.pushAlarmPoint("alarmPoint", alarmPointService.findAll());
                }
            } else {
                //不存在，判断当前状态是不是合格，不合格新增，合格不做任何操作
                if (statusByName != 0) {
                    //增加告警
                    AlarmPoint alarmPoint1 = new AlarmPoint();
                    alarmPoint1.setPointId(eqpId);
                    alarmPoint1.setPointType(AlarmPointTypeEnum.设备.getCode());
                    alarmPoint1.setUpdateDate(new Date());
                    alarmPoint1.setIsAlarm(1);//不合格
                    alarmPoint1.setContent(eqpName + "-" + ipAddress + "-" + metricKey);
                    alarmPoint1.setCode(orgCode1);
                    alarmPoint1.setPointName(eqpName);
                    Map<String, Object> map = new HashMap<>();
                    map.put("position", sanwei);
                    map.put("storey", lou);
                    map.put("levelStr", "impEqu_04");

                    alarmPoint1.setPointAttrs(JSON.toJSONString(map));
                    alarmPointService.save(alarmPoint1);
                    //推送告警
                    amosWsService.pushAlarmPoint("alarmPoint", alarmPointService.findAll());
                }
            }

            //增建告警记录表            
            //告警记录
            List<Alarm> curAlarmList = alarmService.findByQueryColumn(eqpId + metricKey);
            if (curAlarmList != null && curAlarmList.size() > 0) {
                Alarm alarm = curAlarmList.get(0);
                alarm.setUpdateDate(DateTimeKit.now());
                if (!ObjectUtils.isEmpty(alarm.getHappenDate())) {
                    String subtract = DateTimeKit.getSubtract(alarm.getHappenDate());
                    alarm.setContinueDate(subtract);
                }
                if (ALARM_ABNORMAL_STATUS.equals(alarm.getCurrentState()) && statusByName != 0) {
                    alarm.setCurrentState(ALARM_ABNORMAL_STATUS);
                } else {
                    alarm.setClearDate(DateTimeKit.now());
                    alarm.setClearPerson(CLEAR_PERSON);
                    alarm.setCurrentState(ALARM_NORMAL_STATUS);
                }
                alarmMapper.updateAlarm(alarm);
            } else {
                Alarm alarm = new Alarm();
                alarm.setSourceId(eqpId + "");
                alarm.setAlarmLevel(ALARM_LEVEL);
                alarm.setAlarmReason(ALARM_CAUSE);
                alarm.setAlarmSourceIp(ipAddress + "");
                alarm.setAlarmSourceName(eqpName);
                alarm.setAlarmSourceType(ALARM_TYPE);
                alarm.setClearDate("");
                alarm.setContinueDate("");
                alarm.setEnsureDate("");
                alarm.setEnsurePerson("");
                alarm.setOrgCode(orgCode1);
                alarm.setQueryColumn(eqpId + metricKey);
                alarm.setHappenDate(DateTimeKit.now());
                if (statusByName != 0) {
                    alarm.setCurrentState(ALARM_ABNORMAL_STATUS);
                    iAlarmDao.save(alarm);
                } else {
                    alarm.setCurrentState(ALARM_NORMAL_STATUS);
                }
            }
        } catch (Exception e) {
            logger.error("消息流转报错.");
            logger.error(e.getMessage(), e);
            e.printStackTrace();
        }
    }


    public String getIpAddress1(JSONArray eqpConfigMap, String name) {
        //配置信息
        if (null != eqpConfigMap && eqpConfigMap.size() > 0) {
            for (Object object : eqpConfigMap) {
                JSONObject obj = (JSONObject) object;
                String str = obj.getString("displayName");
                if (str.contains(name)) {
                    String ip = obj.getString("valueStr");
                    return ip;
                }
            }
        }
        return null;
    }


    public String getIpAddress(JSONArray eqpConfigMap) {
        //配置信息
        if (null != eqpConfigMap && eqpConfigMap.size() > 0) {
            for (Object object : eqpConfigMap) {
                JSONObject obj = (JSONObject) object;
                String str = obj.getString("displayName");
                if (str.contains("IP")) {
                    String ip = obj.getString("valueStr");
                    return ip;
                }
            }
        }
        return null;
    }
}
