package com.yeejoin.amos.bank.controller;

import com.alibaba.fastjson.JSONArray;
import com.yeejoin.amos.bank.entity.AlarmExcel;
import com.yeejoin.amos.bank.entity.PageModel;
import com.yeejoin.amos.bank.params.WarnParam;
import com.yeejoin.amos.bank.service.WarnService;
import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.spc.core.util.FileHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

/**
 * @Author: xinglei
 * @Description: 告警信息Controller
 * @Date: 2019/12/3 19:15
 */
@RestController
@RequestMapping(value = "/bank/warn")
@Api(value = "/bank/warn", tags = {"告警信息API"})
@Slf4j
public class WarnController {

    @Autowired
    private WarnService warnService;

    @GetMapping(value = "/getWarnings", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "获取告警信息列表", notes = "获取告警信息列表")
    public CommonResponse getWarnings() {
        JSONArray warnings = warnService.getWarnings();
        return CommonResponseUtil.success(warnings);
    }

    @ApiOperation(httpMethod = "POST", value = "分页查询告警信息", notes = "分页查询告警信息")
    @PostMapping(value = "/getWarningsByPage", produces = "application/json;charset=UTF-8")
    public CommonResponse getWarningsByPage(@ApiParam(value = "", required = false) @RequestBody WarnParam param) {
        PageModel pm = warnService.getWarningsByPage(param);
        return CommonResponseUtil.success(pm, "查询成功");
    }

    @GetMapping(value = "/excel")
    @ApiOperation(value = "导出告警信息excel数据", notes = "导出告警信息excel数据")
    public void exportExcel(HttpServletResponse response) {
        List<AlarmExcel> alarmExcels = warnService.getAlarmExcel();
        String fileName = formatName();
        FileHelper.exportExcel(alarmExcels, "告警信息", "告警信息", AlarmExcel.class, fileName, response);
    }

    private String formatName(){
        Calendar calen = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmss");
        String name = sdf.format(calen.getTime()) + ".xls";
        return name;
    }
}
